/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.scheduling;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.connector.datagen.source.DataGeneratorSource;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class RestartStrategyITCase {
    RestartStrategyITCase() {
    }

    private static Stream<Arguments> provideRuntimeModeAndSchedulerParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{RuntimeExecutionMode.STREAMING, JobManagerOptions.SchedulerType.Default}), Arguments.of((Object[])new Object[]{RuntimeExecutionMode.STREAMING, JobManagerOptions.SchedulerType.Adaptive}), Arguments.of((Object[])new Object[]{RuntimeExecutionMode.BATCH, JobManagerOptions.SchedulerType.Default}), Arguments.of((Object[])new Object[]{RuntimeExecutionMode.BATCH, JobManagerOptions.SchedulerType.AdaptiveBatch}));
    }

    @ParameterizedTest
    @MethodSource(value={"provideRuntimeModeAndSchedulerParameters"})
    void testExponentialDelayRestartStrategyAttempts(RuntimeExecutionMode runtimeExecutionMode, JobManagerOptions.SchedulerType schedulerType) throws Exception {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.EXPONENTIAL_DELAY.getMainValue());
        conf.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF, (Object)Duration.ofSeconds(1L));
        conf.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF, (Object)Duration.ofSeconds(3L));
        conf.set(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS, (Object)3);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setRuntimeMode(runtimeExecutionMode);
        conf.set(JobManagerOptions.SCHEDULER, (Object)schedulerType);
        env.setParallelism(1);
        env.configure((ReadableConfig)conf);
        FailureCountableSink failureCountableSink = new FailureCountableSink();
        env.fromSource((Source)new DataGeneratorSource((GeneratorFunction & Serializable)value -> value, 3000L, RateLimiterStrategy.perSecond((double)100.0), Types.LONG), WatermarkStrategy.noWatermarks(), "Data Generator").addSink(failureCountableSink).name("MySink");
        JobClient jobClient = env.executeAsync();
        Assertions.assertThatThrownBy(() -> {
            JobExecutionResult cfr_ignored_0 = (JobExecutionResult)jobClient.getJobExecutionResult().get();
        }).cause().cause().hasMessageContaining("Recovery is suppressed by ExponentialDelayRestartBackoffTimeStrategy").hasRootCauseMessage("Expected exception.");
        Assertions.assertThat((long)failureCountableSink.getFailureCounter()).isEqualTo(4L);
    }

    private static class FailureCountableSink<IN>
    extends RichSinkFunction<IN> {
        private static final AtomicLong failureCounter = new AtomicLong();

        public FailureCountableSink() {
            failureCounter.set(0L);
        }

        public void invoke(IN value, SinkFunction.Context context) {
            failureCounter.incrementAndGet();
            throw new RuntimeException("Expected exception.");
        }

        public long getFailureCounter() {
            return failureCounter.get();
        }
    }
}

