/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.state.operator.restore.keyed;

import org.apache.flink.FlinkVersion;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.state.operator.restore.AbstractOperatorRestoreTestBase;
import org.apache.flink.test.state.operator.restore.ExecutionMode;
import org.apache.flink.test.state.operator.restore.keyed.KeyedJob;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractKeyedOperatorRestoreTestBase
extends AbstractOperatorRestoreTestBase {
    public AbstractKeyedOperatorRestoreTestBase(FlinkVersion flinkVersion) {
        super(flinkVersion);
    }

    @Override
    public void createMigrationJob(StreamExecutionEnvironment env) {
        SingleOutputStreamOperator<Tuple2<Integer, Integer>> source = KeyedJob.createIntegerTupleSource(env, ExecutionMode.MIGRATE);
        SingleOutputStreamOperator<Integer> window = KeyedJob.createWindowFunction(ExecutionMode.MIGRATE, source);
        SingleOutputStreamOperator<Integer> first = KeyedJob.createFirstStatefulMap(ExecutionMode.MIGRATE, window);
        SingleOutputStreamOperator<Integer> second = KeyedJob.createSecondStatefulMap(ExecutionMode.MIGRATE, first);
    }

    @Override
    protected String getMigrationSavepointName(FlinkVersion flinkVersion) {
        return "complexKeyed-flink" + flinkVersion;
    }
}

