/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import sun.misc.Unsafe;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class UnsafeAccess {
    private static final Log LOG = LogFactory.getLog(UnsafeAccess.class);
    public static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(null);
            }
            catch (Throwable e) {
                LOG.warn((Object)"sun.misc.Unsafe is not accessible", e);
                return null;
            }
        }
    });
    public static final int BYTE_ARRAY_BASE_OFFSET = theUnsafe != null ? theUnsafe.arrayBaseOffset(byte[].class) : -1;
    public static final boolean littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    private UnsafeAccess() {
    }

    public static boolean isAvailable() {
        return theUnsafe != null;
    }
}

