// Autogenerated Jamon implementation
// /Users/stack/checkouts/hbase.git/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import java.io.IOException;
// 34, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 35, 1
import org.apache.hadoop.hbase.client.TableDescriptor;
// 36, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 37, 1
import org.apache.hadoop.hbase.HConstants;
// 38, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 39, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 40, 1
import org.apache.hadoop.hbase.ServerName;
// 41, 1
import org.apache.hadoop.hbase.TableName;
// 42, 1
import org.apache.hadoop.hbase.client.Admin;
// 43, 1
import org.apache.hadoop.hbase.client.MasterSwitchType;
// 44, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 45, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 46, 1
import org.apache.hadoop.hbase.master.HMaster;
// 47, 1
import org.apache.hadoop.hbase.master.RegionState;
// 48, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 49, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 50, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;
// 51, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;
// 52, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 53, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos.SnapshotDescription;
// 54, 1
import org.apache.hadoop.hbase.tool.Canary;
// 55, 1
import org.apache.hadoop.hbase.util.Bytes;
// 56, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 57, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 58, 1
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final String format;
  private final Map<String,Integer> frags;
  private final ServerName metaLocation;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  // 70, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  // 97, 1
  
  public static String getUserTables(HMaster master, List<TableDescriptor> tables){
    if (master.isInitialized()){
      try {
        Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
        if (descriptorMap != null) {
          for (TableDescriptor desc : descriptorMap.values()) {
            if (!desc.getTableName().isSystemTable()) {
             tables.add(desc);
            }
          }
        }
      } catch (IOException e) {
        return "Got user tables error, " + e.getMessage();
      }
    }
    return null;
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    metaLocation = p_implData.getMetaLocation();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 61, 1
    if (format.equals("json") )
    {
      // 61, 30
      jamonWriter.write("\n  ");
      // 62, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 62, 68
      jamonWriter.write("\n  ");
      // 63, 3
      return; 
    }
    // 64, 7
    jamonWriter.write("\n");
    // 65, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 117, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 122, 12
    if (master.isActiveMaster() )
    {
      // 122, 43
      jamonWriter.write("Master: ");
    }
    // 122, 51
    else
    {
      // 122, 58
      jamonWriter.write("Backup Master: ");
    }
    // 122, 79
    jamonWriter.write("\n    ");
    // 123, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 123, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
    // 147, 17
    if (master.isActiveMaster() )
    {
      // 147, 48
      jamonWriter.write("\n                <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                ");
    }
    // 149, 23
    jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 155, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 155, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 157, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 164, 2
    if (master.isActiveMaster() )
    {
      // 164, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 167, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 167, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 173, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 173, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 175, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 175, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
      }
      // 180, 15
      jamonWriter.write("\n        ");
      // 181, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 181, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 186, 15
      jamonWriter.write("\n        ");
      // 187, 9
      if (master.isInMaintenanceMode() )
      {
        // 187, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This may be because of HBCK aborting while\n          running in repair mode. Please re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 192, 15
      jamonWriter.write("\n        ");
      // 193, 9
      if (!master.isBalancerOn() )
      {
        // 193, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 199, 15
      jamonWriter.write("\n        ");
      // 200, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT) )
      {
        // 200, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 206, 15
      jamonWriter.write("\n        ");
      // 207, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.MERGE) )
      {
        // 207, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 213, 15
      jamonWriter.write("\n        ");
      // 214, 9
      if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null )
      {
        // 214, 98
        jamonWriter.write("\n          <section>\n            <h2>RSGroup</h2>\n            ");
        // 217, 13
        {
          org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl(this.getTemplateManager());
          __jamon__var_1.renderNoFlush(jamonWriter, master, serverManager);
        }
        // 217, 79
        jamonWriter.write("\n          </section>\n        ");
      }
      // 219, 15
      jamonWriter.write("\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 222, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_2.setServers(servers );
        __jamon__var_2.renderNoFlush(jamonWriter, master);
      }
      // 222, 74
      jamonWriter.write("\n\n            ");
      // 224, 13
      if ((deadServers != null) )
      {
        // 224, 42
        jamonWriter.write("\n                ");
        // 225, 17
        {
          // 225, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 225, 40
        jamonWriter.write("\n            ");
      }
      // 226, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 229, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_3.renderNoFlush(jamonWriter, master );
      }
      // 229, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 247, 25
      if ((metaLocation != null) )
      {
        // 247, 55
        jamonWriter.write("\n                            ");
        // 248, 29
        {
          // 248, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 248, 45
        jamonWriter.write("\n                        ");
      }
      // 249, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 252, 25
      if ((metaLocation != null) )
      {
        // 252, 55
        jamonWriter.write("\n                            ");
        // 253, 29
        {
          // 253, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 253, 48
        jamonWriter.write("\n                        ");
      }
      // 254, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 257, 25
      {
        // 257, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 257, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
      // 262, 9
      if (master.getAssignmentManager() != null )
      {
        // 262, 54
        jamonWriter.write("\n        ");
        // 263, 9
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_4.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 263, 90
        jamonWriter.write("\n        ");
      }
      // 264, 15
      jamonWriter.write("\n\t");
    }
    // 265, 2
    else
    {
      // 265, 9
      jamonWriter.write("\n        <section>\n            ");
      // 267, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_5.renderNoFlush(jamonWriter, master );
      }
      // 267, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 269, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 273, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_6 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_6.setFilter(filter );
      __jamon__var_6.renderNoFlush(jamonWriter);
    }
    // 273, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 286, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 286, 84
    jamonWriter.write(", revision=");
    // 286, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 286, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 290, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 290, 81
    jamonWriter.write(", ");
    // 290, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 290, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 295, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 295, 88
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 300, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 300, 78
    jamonWriter.write(", revision=");
    // 300, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 300, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 305, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 305, 75
    jamonWriter.write(", ");
    // 305, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 305, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 310, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 310, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 315, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 315, 72
    jamonWriter.write(", revision=");
    // 315, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 315, 131
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 320, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 320, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
    // 326, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 326, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
    // 331, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 331, 79
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 336, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 336, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 341, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 341, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 344, 17
    if (master.isActiveMaster() )
    {
      // 344, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 347, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 347, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 352, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 352, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 357, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 358, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 361, 18
      if (frags != null )
      {
        // 361, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 364, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 364, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 367, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 370, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 371, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 376, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 376, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 379, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
  }
  
  
  // 391, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 392, 1
    
 List<TableDescriptor> sysTables = master.isInitialized() ?
   master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;

    // 396, 1
    if ((sysTables != null && sysTables.size() > 0))
    {
      // 396, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 400, 5
      if ((frags != null) )
      {
        // 400, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 402, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 405, 1
      for (TableDescriptor systemTable : sysTables)
      {
        // 405, 48
        jamonWriter.write("\n<tr>\n");
        // 407, 1
        TableName tableName = systemTable.getTableName();
        // 408, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 408, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 408, 48
        jamonWriter.write("\">");
        // 408, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 408, 65
        jamonWriter.write("</a></td>\n    ");
        // 409, 5
        if ((frags != null))
        {
          // 409, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 410, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 411, 37
          jamonWriter.write("</td>\n    ");
        }
        // 412, 11
        jamonWriter.write("\n    ");
        // 413, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(Canary.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl.";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups.";
        } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
            description = "The hbase:replication table tracks cross cluster replication through " +
            "WAL file offsets.";
        }
    
        // 435, 5
        jamonWriter.write("<td>");
        // 435, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 435, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 437, 8
      jamonWriter.write("\n</table>\n");
    }
    // 439, 7
    jamonWriter.write("\n");
  }
  
  
  // 535, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 537, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 537, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 545, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 551, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 553, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 553, 33
      jamonWriter.write("</td>\n        <td>");
      // 554, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 554, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 556, 5
      
        }
    
      // 559, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 561, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 561, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 565, 7
    jamonWriter.write("\n");
  }
  
  
  // 506, 1
  private void __jamon_innerUnit__userSnapshots(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 507, 1
    
   List<SnapshotDescription> snapshots = master.isInitialized() ?
     master.getSnapshotManager().getCompletedSnapshots() : null;

    // 511, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 511, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 518, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 518, 57
        jamonWriter.write("\n    ");
        // 519, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 522, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 523, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 523, 68
        jamonWriter.write("\">");
        // 523, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 523, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 524, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 524, 74
        jamonWriter.write("\">");
        // 524, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 524, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 526, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 526, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 528, 12
      jamonWriter.write("\n    <p>");
      // 529, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 529, 30
      jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
    }
    // 531, 7
    jamonWriter.write("\n");
  }
  
  
  // 442, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 443, 1
    
   List<TableDescriptor> tables = new ArrayList<TableDescriptor>();
   String errorMessage = getUserTables(master, tables);

    // 447, 1
    if ((tables.size() == 0 && errorMessage != null))
    {
      // 447, 52
      jamonWriter.write("\n<p> ");
      // 448, 5
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(errorMessage), jamonWriter);
      // 448, 23
      jamonWriter.write(" </p>\n");
    }
    // 449, 7
    jamonWriter.write("\n\n");
    // 451, 1
    if ((tables != null && tables.size() > 0))
    {
      // 451, 45
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
      // 456, 9
      if ((frags != null) )
      {
        // 456, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 458, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Offline Regions</th>\n        <th>Failed Regions</th>\n        <th>Split Regions</th>\n        <th>Other Regions</th>\n        <th>Description</th>\n    </tr>\n    ");
      // 466, 5
      for (TableDescriptor desc : tables)
      {
        // 466, 42
        jamonWriter.write("\n    ");
        // 467, 5
        
      HTableDescriptor htDesc = new HTableDescriptor(desc);
      TableName tableName = htDesc.getTableName();
      Map<RegionState.State, List<RegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<RegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount;
    
        // 487, 5
        jamonWriter.write("<tr>\n        <td>");
        // 488, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 488, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 489, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
        // 489, 69
        jamonWriter.write(">");
        // 489, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
        // 489, 108
        jamonWriter.write("</a> </td>\n        ");
        // 490, 9
        if ((frags != null) )
        {
          // 490, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 491, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 491, 150
          jamonWriter.write("</td>\n        ");
        }
        // 492, 15
        jamonWriter.write("\n        <td>");
        // 493, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 493, 35
        jamonWriter.write("</td>\n        <td>");
        // 494, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 494, 38
        jamonWriter.write("</td>\n        <td>");
        // 495, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 495, 37
        jamonWriter.write("</td>\n        <td>");
        // 496, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 496, 36
        jamonWriter.write("</td>\n        <td>");
        // 497, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 497, 36
        jamonWriter.write("</td>\n        <td>");
        // 498, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 498, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 500, 12
      jamonWriter.write("\n    <p>");
      // 501, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.size()), jamonWriter);
      // 501, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
    }
    // 503, 7
    jamonWriter.write("\n");
  }
  
  
}
