/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsHBaseServerWrapperImpl
implements MetricsHBaseServerWrapper {
    private RpcServer server;

    MetricsHBaseServerWrapperImpl(RpcServer server) {
        this.server = server;
    }

    private boolean isServerStarted() {
        return this.server != null && this.server.isStarted();
    }

    public long getTotalQueueSize() {
        if (!this.isServerStarted()) {
            return 0L;
        }
        return this.server.callQueueSizeInBytes.sum();
    }

    public int getGeneralQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getGeneralQueueLength();
    }

    public int getReplicationQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReplicationQueueLength();
    }

    public int getPriorityQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getPriorityQueueLength();
    }

    public int getNumOpenConnections() {
        if (!this.isServerStarted()) {
            return 0;
        }
        return this.server.getNumOpenConnections();
    }

    public int getActiveRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveRpcHandlerCount();
    }

    public long getNumGeneralCallsDropped() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0L;
        }
        return this.server.getScheduler().getNumGeneralCallsDropped();
    }

    public long getNumLifoModeSwitches() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0L;
        }
        return this.server.getScheduler().getNumLifoModeSwitches();
    }

    public int getWriteQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getWriteQueueLength();
    }

    public int getReadQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReadQueueLength();
    }

    public int getScanQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getScanQueueLength();
    }

    public int getActiveWriteRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveWriteRpcHandlerCount();
    }

    public int getActiveReadRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveReadRpcHandlerCount();
    }

    public int getActiveScanRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveScanRpcHandlerCount();
    }
}

