/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool.coprocessor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.tool.coprocessor.Branch1CoprocessorMethods;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorMethods;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorViolation;
import org.apache.hadoop.hbase.tool.coprocessor.CurrentCoprocessorMethods;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class CoprocessorValidator
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(CoprocessorValidator.class);
    private CoprocessorMethods branch1 = new Branch1CoprocessorMethods();
    private CoprocessorMethods current = new CurrentCoprocessorMethods();
    private boolean dieOnWarnings;
    private boolean scan;
    private List<String> args;

    private ResolverUrlClassLoader createClassLoader(final URL[] urls) {
        return AccessController.doPrivileged(new PrivilegedAction<ResolverUrlClassLoader>(){

            @Override
            public ResolverUrlClassLoader run() {
                return new ResolverUrlClassLoader(urls);
            }
        });
    }

    private void validate(ClassLoader classLoader, String className, List<CoprocessorViolation> violations) {
        LOG.debug("Validating class '{}'.", (Object)className);
        try {
            Class<?> clazz = classLoader.loadClass(className);
            for (Method method : clazz.getDeclaredMethods()) {
                LOG.trace("Validating method '{}'.", (Object)method);
                if (!this.branch1.hasMethod(method) || this.current.hasMethod(method)) continue;
                CoprocessorViolation violation = new CoprocessorViolation(CoprocessorViolation.Severity.WARNING, "Method '" + method + "' was removed from new coprocessor API, so it won't be called by HBase.");
                violations.add(violation);
            }
        }
        catch (ClassNotFoundException e) {
            CoprocessorViolation violation = new CoprocessorViolation(CoprocessorViolation.Severity.ERROR, "No such class '" + className + "'.", e);
            violations.add(violation);
        }
        catch (Error | RuntimeException e) {
            CoprocessorViolation violation = new CoprocessorViolation(CoprocessorViolation.Severity.ERROR, "Could not validate class '" + className + "'.", e);
            violations.add(violation);
        }
    }

    public List<CoprocessorViolation> validate(ClassLoader classLoader, List<String> classNames) {
        ArrayList<CoprocessorViolation> violations = new ArrayList<CoprocessorViolation>();
        for (String className : classNames) {
            this.validate(classLoader, className, violations);
        }
        return violations;
    }

    public List<CoprocessorViolation> validate(List<URL> urls, List<String> classNames) throws IOException {
        URL[] urlArray = new URL[urls.size()];
        urls.toArray(urlArray);
        try (ResolverUrlClassLoader classLoader = this.createClassLoader(urlArray);){
            List<CoprocessorViolation> list = this.validate(classLoader, classNames);
            return list;
        }
    }

    @VisibleForTesting
    protected List<String> getJarClasses(Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            List<String> list = jarFile.stream().map(ZipEntry::getName).filter(name -> name.endsWith(".class")).map(name -> name.substring(0, name.length() - 6).replace('/', '.')).collect(Collectors.toList());
            return list;
        }
    }

    @VisibleForTesting
    protected List<String> filterObservers(ClassLoader classLoader, Iterable<String> classNames) throws ClassNotFoundException {
        ArrayList<String> filteredClassNames = new ArrayList<String>();
        for (String className : classNames) {
            LOG.debug("Scanning class '{}'.", (Object)className);
            Class<?> clazz = classLoader.loadClass(className);
            if (!Coprocessor.class.isAssignableFrom(clazz)) continue;
            LOG.debug("Found coprocessor class '{}'.", (Object)className);
            filteredClassNames.add(className);
        }
        return filteredClassNames;
    }

    protected void printUsage() {
        String header = "hbase pre-upgrade validate-cp <jar> -scan|<classes>";
        this.printUsage(header, "Options:", "");
    }

    protected void addOptions() {
        this.addOptNoArg("e", "Treat warnings as errors.");
        this.addOptNoArg("scan", "Scan jar for observers.");
    }

    protected void processOptions(CommandLine cmd) {
        this.scan = cmd.hasOption("scan");
        this.dieOnWarnings = cmd.hasOption("e");
        this.args = cmd.getArgList();
    }

    protected int doWork() throws Exception {
        List<CoprocessorViolation> violations;
        if (this.args.size() < 1) {
            System.err.println("Missing jar file.");
            this.printUsage();
            return 1;
        }
        String jar = this.args.get(0);
        if (this.args.size() == 1 && !this.scan) {
            throw new ParseException("Missing classes or -scan option.");
        }
        if (this.args.size() > 1 && this.scan) {
            throw new ParseException("Can't use classes with -scan option.");
        }
        Path jarPath = Paths.get(jar, new String[0]);
        URL[] urls = new URL[]{jarPath.toUri().toURL()};
        ResolverUrlClassLoader classLoader = this.createClassLoader(urls);
        Object object = null;
        try {
            List<String> classNames;
            if (this.scan) {
                List<String> jarClassNames = this.getJarClasses(jarPath);
                classNames = this.filterObservers(classLoader, jarClassNames);
            } else {
                classNames = this.args.subList(1, this.args.size());
            }
            violations = this.validate(classLoader, classNames);
        }
        catch (Throwable classNames) {
            object = classNames;
            throw classNames;
        }
        finally {
            if (classLoader != null) {
                if (object != null) {
                    try {
                        classLoader.close();
                    }
                    catch (Throwable classNames) {
                        ((Throwable)object).addSuppressed(classNames);
                    }
                } else {
                    classLoader.close();
                }
            }
        }
        boolean error = false;
        for (CoprocessorViolation violation : violations) {
            switch (violation.getSeverity()) {
                case WARNING: {
                    System.err.println("[WARNING] " + violation.getMessage());
                    if (!this.dieOnWarnings) break;
                    error = true;
                    break;
                }
                case ERROR: {
                    System.err.println("[ERROR] " + violation.getMessage());
                    error = true;
                }
            }
        }
        return error ? 1 : 0;
    }

    private static final class ResolverUrlClassLoader
    extends URLClassLoader {
        private ResolverUrlClassLoader(URL[] urls) {
            super(urls, ResolverUrlClassLoader.class.getClassLoader());
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, true);
        }
    }
}

