/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServerPreambleHandler;
import org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServerResponseEncoder;
import org.apache.hadoop.hbase.ipc.NettyServerCall;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcSchedulerContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.ServerChannel;
import org.apache.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import org.apache.hbase.thirdparty.io.netty.channel.group.DefaultChannelGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hbase.thirdparty.io.netty.handler.codec.FixedLengthFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.EventExecutor;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcServer
extends RpcServer {
    public static final Logger LOG = LoggerFactory.getLogger(NettyRpcServer.class);
    private final InetSocketAddress bindAddress;
    private final CountDownLatch closed = new CountDownLatch(1);
    private final Channel serverChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public NettyRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler, boolean reservoirEnabled) throws IOException {
        super(server, name, services, bindAddress, conf, scheduler, reservoirEnabled);
        Class<? extends ServerChannel> channelClass;
        EventLoopGroup eventLoopGroup;
        this.bindAddress = bindAddress;
        if (server instanceof HRegionServer) {
            NettyEventLoopGroupConfig config = ((HRegionServer)server).getEventLoopGroupConfig();
            eventLoopGroup = config.group();
            channelClass = config.serverChannelClass();
        } else {
            eventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("NettyRpcServer", true, 10));
            channelClass = NioServerSocketChannel.class;
        }
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(channelClass)).childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                FixedLengthFrameDecoder preambleDecoder = new FixedLengthFrameDecoder(6);
                preambleDecoder.setSingleDecode(true);
                pipeline.addLast("preambleDecoder", (ChannelHandler)preambleDecoder);
                pipeline.addLast("preambleHandler", (ChannelHandler)NettyRpcServer.this.createNettyRpcServerPreambleHandler());
                pipeline.addLast("frameDecoder", (ChannelHandler)new NettyRpcFrameDecoder(NettyRpcServer.this.maxRequestSize));
                pipeline.addLast("decoder", (ChannelHandler)new NettyRpcServerRequestDecoder(NettyRpcServer.this.allChannels, NettyRpcServer.this.metrics));
                pipeline.addLast("encoder", (ChannelHandler)new NettyRpcServerResponseEncoder(NettyRpcServer.this.metrics));
            }
        });
        try {
            this.serverChannel = bootstrap.bind((SocketAddress)this.bindAddress).sync().channel();
            LOG.info("Bind to {}", (Object)this.serverChannel.localAddress());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        this.initReconfigurable(conf);
        this.scheduler.init(new RpcSchedulerContext(this));
    }

    @VisibleForTesting
    protected NettyRpcServerPreambleHandler createNettyRpcServerPreambleHandler() {
        return new NettyRpcServerPreambleHandler(this);
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.authTokenSecretMgr = this.createSecretManager();
        if (this.authTokenSecretMgr != null) {
            this.setSecretManager(this.authTokenSecretMgr);
            this.authTokenSecretMgr.start();
        }
        this.authManager = new ServiceAuthorizationManager();
        HBasePolicyProvider.init(this.conf, this.authManager);
        this.scheduler.start();
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        LOG.info("Stopping server on " + this.serverChannel.localAddress());
        if (this.authTokenSecretMgr != null) {
            this.authTokenSecretMgr.stop();
            this.authTokenSecretMgr = null;
        }
        this.allChannels.close().awaitUninterruptibly();
        this.serverChannel.close();
        this.scheduler.stop();
        this.closed.countDown();
        this.running = false;
    }

    @Override
    public synchronized void join() throws InterruptedException {
        this.closed.await();
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        return (InetSocketAddress)this.serverChannel.localAddress();
    }

    @Override
    public void setSocketSendBufSize(int size) {
    }

    @Override
    public int getNumOpenConnections() {
        return this.allChannels.size() - 1;
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
        return this.call(service, md, param, cellScanner, receiveTime, status, System.currentTimeMillis(), 0);
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status, long startTime, int timeout) throws IOException {
        NettyServerCall fakeCall = new NettyServerCall(-1, service, md, null, param, cellScanner, null, -1L, null, receiveTime, timeout, this.reservoir, this.cellBlockBuilder, null);
        return this.call(fakeCall, status);
    }
}

