/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hbase.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.hbase.thirdparty.io.netty.bootstrap.ChannelFactory;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelException;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.DatagramChannel;
import org.apache.hbase.thirdparty.io.netty.channel.socket.DatagramPacket;
import org.apache.hbase.thirdparty.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClusterStatusPublisher
extends ScheduledChore {
    public static final String STATUS_PUBLISHER_CLASS = "hbase.status.publisher.class";
    public static final Class<? extends Publisher> DEFAULT_STATUS_PUBLISHER_CLASS = MulticastPublisher.class;
    public static final String STATUS_PUBLISH_PERIOD = "hbase.status.publish.period";
    public static final int DEFAULT_STATUS_PUBLISH_PERIOD = 10000;
    private long lastMessageTime = 0L;
    private final HMaster master;
    private final int messagePeriod;
    private final ConcurrentMap<ServerName, Integer> lastSent = new ConcurrentHashMap<ServerName, Integer>();
    private Publisher publisher;
    private boolean connected = false;
    public static final int MAX_SERVER_PER_MESSAGE = 10;
    public static final int NB_SEND = 5;

    public ClusterStatusPublisher(HMaster master, Configuration conf, Class<? extends Publisher> publisherClass) throws IOException {
        super("HBase clusterStatusPublisher for " + master.getName(), (Stoppable)master, conf.getInt(STATUS_PUBLISH_PERIOD, 10000));
        this.master = master;
        this.messagePeriod = conf.getInt(STATUS_PUBLISH_PERIOD, 10000);
        try {
            this.publisher = publisherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Can't create publisher " + publisherClass.getName(), e);
        }
        this.publisher.connect(conf);
        this.connected = true;
    }

    protected ClusterStatusPublisher() {
        this.master = null;
        this.messagePeriod = 0;
    }

    protected void chore() {
        if (!this.isConnected()) {
            return;
        }
        List<ServerName> sns = this.generateDeadServersListToSend();
        if (sns.isEmpty()) {
            return;
        }
        long curTime = EnvironmentEdgeManager.currentTime();
        if (this.lastMessageTime > curTime - (long)this.messagePeriod) {
            return;
        }
        this.lastMessageTime = curTime;
        this.publisher.publish(ClusterMetricsBuilder.newBuilder().setHBaseVersion(VersionInfo.getVersion()).setClusterId(this.master.getMasterFileSystem().getClusterId().toString()).setMasterName(this.master.getServerName()).setDeadServerNames(sns).build());
    }

    protected synchronized void cleanup() {
        this.connected = false;
        this.publisher.close();
    }

    private synchronized boolean isConnected() {
        return this.connected;
    }

    protected List<ServerName> generateDeadServersListToSend() {
        long since = EnvironmentEdgeManager.currentTime() - (long)(this.messagePeriod * 2);
        for (Pair<ServerName, Long> dead : this.getDeadServers(since)) {
            this.lastSent.putIfAbsent((ServerName)dead.getFirst(), 0);
        }
        ArrayList entries = new ArrayList();
        entries.addAll(this.lastSent.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<ServerName, Integer>>(){

            @Override
            public int compare(Map.Entry<ServerName, Integer> o1, Map.Entry<ServerName, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        int max = entries.size() > 10 ? 10 : entries.size();
        ArrayList<ServerName> res = new ArrayList<ServerName>(max);
        for (int i = 0; i < max; ++i) {
            Map.Entry toSend = (Map.Entry)entries.get(i);
            if ((Integer)toSend.getValue() >= 4) {
                this.lastSent.remove(toSend.getKey());
            } else {
                this.lastSent.replace((ServerName)toSend.getKey(), (Integer)toSend.getValue(), (Integer)toSend.getValue() + 1);
            }
            res.add((ServerName)toSend.getKey());
        }
        return res;
    }

    protected List<Pair<ServerName, Long>> getDeadServers(long since) {
        if (this.master.getServerManager() == null) {
            return Collections.emptyList();
        }
        return this.master.getServerManager().getDeadServers().copyDeadServersSince(since);
    }

    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    public static class MulticastPublisher
    implements Publisher {
        private DatagramChannel channel;
        private final EventLoopGroup group = new NioEventLoopGroup(1, Threads.newDaemonThreadFactory((String)"hbase-master-clusterStatusPublisher"));

        @Override
        public void connect(Configuration conf) throws IOException {
            NetworkInterface ni;
            InternetProtocolFamily family;
            InetAddress ina;
            String mcAddress = conf.get("hbase.status.multicast.address.ip", "226.1.1.3");
            int port = conf.getInt("hbase.status.multicast.address.port", 16100);
            String bindAddress = conf.get("hbase.status.multicast.publisher.bind.address.ip", "0.0.0.0");
            String niName = conf.get("hbase.status.multicast.ni.name");
            try {
                ina = InetAddress.getByName(mcAddress);
            }
            catch (UnknownHostException e) {
                this.close();
                throw new IOException("Can't connect to " + mcAddress, e);
            }
            InetSocketAddress isa = new InetSocketAddress(mcAddress, port);
            if (niName != null) {
                family = ina instanceof Inet6Address ? InternetProtocolFamily.IPv6 : InternetProtocolFamily.IPv4;
                ni = NetworkInterface.getByName(niName);
            } else {
                InetAddress localAddress;
                if (ina instanceof Inet6Address) {
                    localAddress = Addressing.getIp6Address();
                    family = InternetProtocolFamily.IPv6;
                } else {
                    localAddress = Addressing.getIp4Address();
                    family = InternetProtocolFamily.IPv4;
                }
                ni = NetworkInterface.getByInetAddress(localAddress);
            }
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channelFactory(new HBaseDatagramChannelFactory<NioDatagramChannel>(NioDatagramChannel.class, family))).option(ChannelOption.SO_REUSEADDR, (Object)true)).handler((ChannelHandler)new ClusterMetricsEncoder(isa));
            try {
                this.channel = (DatagramChannel)b.bind(bindAddress, 0).sync().channel();
                this.channel.joinGroup(ina, ni, null, this.channel.newPromise()).sync();
                this.channel.connect((SocketAddress)isa).sync();
            }
            catch (InterruptedException e) {
                this.close();
                throw ExceptionUtil.asInterrupt((Throwable)e);
            }
        }

        @Override
        public void publish(ClusterMetrics cs) {
            this.channel.writeAndFlush((Object)cs).syncUninterruptibly();
        }

        @Override
        public void close() {
            if (this.channel != null) {
                this.channel.close();
            }
            this.group.shutdownGracefully();
        }

        private static final class ClusterMetricsEncoder
        extends MessageToMessageEncoder<ClusterMetrics> {
            private final InetSocketAddress isa;

            private ClusterMetricsEncoder(InetSocketAddress isa) {
                this.isa = isa;
            }

            protected void encode(ChannelHandlerContext channelHandlerContext, ClusterMetrics clusterStatus, List<Object> objects) {
                objects.add(new DatagramPacket(Unpooled.wrappedBuffer((byte[])ClusterMetricsBuilder.toClusterStatus((ClusterMetrics)clusterStatus).toByteArray()), this.isa));
            }
        }

        private static final class HBaseDatagramChannelFactory<T extends Channel>
        implements ChannelFactory<T> {
            private final Class<? extends T> clazz;
            private InternetProtocolFamily family;

            HBaseDatagramChannelFactory(Class<? extends T> clazz, InternetProtocolFamily family) {
                this.clazz = clazz;
                this.family = family;
            }

            public T newChannel() {
                try {
                    return (T)((Channel)ReflectionUtils.instantiateWithCustomCtor((String)this.clazz.getName(), (Class[])new Class[]{InternetProtocolFamily.class}, (Object[])new Object[]{this.family}));
                }
                catch (Throwable t) {
                    throw new ChannelException("Unable to create Channel from class " + this.clazz, t);
                }
            }

            public String toString() {
                return StringUtil.simpleClassName(this.clazz) + ".class";
            }
        }
    }

    public static interface Publisher
    extends Closeable {
        public void connect(Configuration var1) throws IOException;

        public void publish(ClusterMetrics var1);

        @Override
        public void close();
    }
}

