/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class FSWALEntry
extends WAL.Entry {
    private final transient long txid;
    private final transient boolean inMemstore;
    private final transient RegionInfo regionInfo;
    private final transient Set<byte[]> familyNames;

    FSWALEntry(long txid, WALKeyImpl key, WALEdit edit, RegionInfo regionInfo, boolean inMemstore) {
        super(key, edit);
        this.inMemstore = inMemstore;
        this.regionInfo = regionInfo;
        this.txid = txid;
        this.familyNames = inMemstore ? FSWALEntry.collectFamilies(edit.getCells()) : Collections.emptySet();
    }

    @VisibleForTesting
    static Set<byte[]> collectFamilies(List<Cell> cells) {
        if (CollectionUtils.isEmpty(cells)) {
            return Collections.emptySet();
        }
        return cells.stream().filter(v -> !CellUtil.matchingFamily((Cell)v, (byte[])WALEdit.METAFAMILY)).collect(Collectors.toCollection(() -> new TreeSet((arg_0, arg_1) -> ((CellComparator)CellComparator.getInstance()).compareFamilies(arg_0, arg_1)))).stream().map(CellUtil::cloneFamily).collect(Collectors.toCollection(() -> new TreeSet(Bytes.BYTES_COMPARATOR)));
    }

    @Override
    public String toString() {
        return "sequence=" + this.txid + ", " + super.toString();
    }

    boolean isInMemStore() {
        return this.inMemstore;
    }

    RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    long getTxid() {
        return this.txid;
    }

    long stampRegionSequenceId(MultiVersionConcurrencyControl.WriteEntry we) throws IOException {
        long regionSequenceId = we.getWriteNumber();
        if (!this.getEdit().isReplay() && this.inMemstore) {
            for (Cell c : this.getEdit().getCells()) {
                PrivateCellUtil.setSequenceId((Cell)c, (long)regionSequenceId);
            }
        }
        this.getKey().setWriteEntry(we);
        return regionSequenceId;
    }

    Set<byte[]> getFamilyNames() {
        return this.familyNames;
    }
}

