/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestSplitMerge {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitMerge.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.meta.operation.timeout", 1000);
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        final TableName tableName = TableName.valueOf((String)"SplitMerge");
        byte[] family = Bytes.toBytes((String)"CF");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        UTIL.getAdmin().createTable(td, (byte[][])new byte[][]{Bytes.toBytes((int)1)});
        UTIL.waitTableAvailable(tableName);
        UTIL.getAdmin().split(tableName, Bytes.toBytes((int)2));
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return UTIL.getMiniHBaseCluster().getRegions(tableName).size() == 3;
            }

            public String explainFailure() throws Exception {
                return "Split has not finished yet";
            }
        });
        RegionInfo regionA = null;
        RegionInfo regionB = null;
        for (RegionInfo region : UTIL.getAdmin().getRegions(tableName)) {
            if (region.getStartKey().length == 0) {
                regionA = region;
                continue;
            }
            if (!Bytes.equals((byte[])region.getStartKey(), (byte[])Bytes.toBytes((int)1))) continue;
            regionB = region;
        }
        Assert.assertNotNull(regionA);
        Assert.assertNotNull(regionB);
        UTIL.getAdmin().mergeRegionsAsync(regionA.getRegionName(), regionB.getRegionName(), false).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)UTIL.getAdmin().getRegions(tableName).size());
        ServerName expected = UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName();
        Assert.assertEquals((Object)expected, (Object)UTIL.getConnection().getRegionLocator(tableName).getRegionLocation(Bytes.toBytes((int)1), true).getServerName());
        try (AsyncConnection asyncConn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();){
            Assert.assertEquals((Object)expected, (Object)((HRegionLocation)asyncConn.getRegionLocator(tableName).getRegionLocation(Bytes.toBytes((int)1), true).get()).getServerName());
        }
    }
}

