/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coordination.ZkSplitLogWorkerCoordination;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestZooKeeper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZooKeeper.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestZooKeeper.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(2);
        TEST_UTIL.startMiniZKCluster();
        conf.setInt("zookeeper.session.timeout", 1000);
        conf.setClass("hbase.master.loadbalancer.class", MockLoadBalancer.class, LoadBalancer.class);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniHBaseCluster(2, 2);
    }

    @After
    public void after() throws Exception {
        try {
            TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster(10000L);
            TEST_UTIL.getHBaseCluster().killAll();
            TEST_UTIL.shutdownMiniHBaseCluster();
        }
        finally {
            TEST_UTIL.getTestFileSystem().delete(FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), true);
            ZKUtil.deleteNodeRecursively((ZKWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)"/hbase");
        }
    }

    @Test
    public void testRegionServerSessionExpired() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        TEST_UTIL.expireRegionServerSession(0);
        this.testSanity(this.name.getMethodName());
    }

    @Test
    public void testMasterSessionExpired() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        TEST_UTIL.expireMasterSession();
        this.testSanity(this.name.getMethodName());
    }

    @Test
    public void testMasterZKSessionRecoveryFailure() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
        Assert.assertTrue((boolean)m.isStopped());
        this.testSanity(this.name.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSanity(String testName) throws Exception {
        String tableName = testName + "_" + System.currentTimeMillis();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam")).build();
        LOG.info("Creating table " + tableName);
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.createTable(desc);
        }
        Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());
        Put put = new Put(Bytes.toBytes((String)"testrow"));
        put.addColumn(Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"testdata"));
        LOG.info("Putting table " + tableName);
        table.put(put);
        table.close();
    }

    @Test
    public void testRegionAssignmentAfterMasterRecoveryDueToZKExpiry() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.startRegionServer();
        cluster.waitForActiveAndReadyMaster(10000L);
        HMaster m = cluster.getMaster();
        ZKWatcher zkw = m.getZooKeeper();
        try (Admin admin = TEST_UTIL.getAdmin();){
            byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i"), Bytes.toBytes((String)"j")};
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
            admin.createTable(htd, (byte[][])SPLIT_KEYS);
            TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            m.getZooKeeper().close();
            MockLoadBalancer.retainAssignCalled = false;
            int expectedNumOfListeners = this.countPermanentListeners(zkw);
            m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
            Assert.assertTrue((boolean)m.isStopped());
            Assert.assertFalse((String)"Retain assignment should not be called", (boolean)MockLoadBalancer.retainAssignCalled);
            cluster.waitForActiveAndReadyMaster(120000L);
            HMaster newMaster = cluster.getMasterThread().getMaster();
            Assert.assertEquals((long)expectedNumOfListeners, (long)this.countPermanentListeners(newMaster.getZooKeeper()));
        }
    }

    private int countPermanentListeners(ZKWatcher watcher) {
        return this.countListeners(watcher, ZkSplitLogWorkerCoordination.class);
    }

    private int countListeners(ZKWatcher watcher, Class<?> ... exclude) {
        int cnt = 0;
        for (Object o : watcher.getListeners()) {
            boolean skip = false;
            for (Class<?> aClass : exclude) {
                if (!aClass.isAssignableFrom(o.getClass())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            ++cnt;
        }
        return cnt;
    }

    @Test
    public void testLogSplittingAfterMasterRecoveryDueToZKExpiry() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.startRegionServer();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family = Bytes.toBytes((String)"col");
        try (Admin admin = TEST_UTIL.getAdmin();){
            byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"5")};
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
            admin.createTable(htd, (byte[][])SPLIT_KEYS);
        }
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        HMaster m = cluster.getMaster();
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            int numberOfPuts;
            for (numberOfPuts = 0; numberOfPuts < 6; ++numberOfPuts) {
                Put p = new Put(Bytes.toBytes((int)numberOfPuts));
                p.addColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)("value" + numberOfPuts)));
                table.put(p);
            }
            m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
            Assert.assertTrue((boolean)m.isStopped());
            cluster.killRegionServer(TEST_UTIL.getRSForFirstRegionInTable(tableName).getServerName());
            int numberOfRows = 0;
            try (ResultScanner scanner = table.getScanner(new Scan());){
                while (scanner.next() != null) {
                    ++numberOfRows;
                }
            }
            Assert.assertEquals((String)"Number of rows should be equal to number of puts.", (long)numberOfPuts, (long)numberOfRows);
        }
    }

    static class MockLoadBalancer
    extends SimpleLoadBalancer {
        static boolean retainAssignCalled = false;

        MockLoadBalancer() {
        }

        public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
            retainAssignCalled = true;
            return super.retainAssignment(regions, servers);
        }
    }
}

