/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncRegionLocatorTimeout {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncRegionLocatorTimeout.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static AsyncConnectionImpl CONN;
    private static AsyncRegionLocator LOCATOR;
    private static volatile long SLEEP_MS;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", SleepRegionObserver.class.getName());
        conf.setLong("hbase.client.meta.operation.timeout", 2000L);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        AsyncRegistry registry = AsyncRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        CONN = new AsyncConnectionImpl(TEST_UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent());
        LOCATOR = CONN.getLocator();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, ExecutionException {
        SLEEP_MS = 1000L;
        long startNs = System.nanoTime();
        try {
            LOCATOR.getRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, TimeUnit.MILLISECONDS.toNanos(500L)).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(TimeoutIOException.class));
        }
        long costMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        Assert.assertTrue((costMs >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((costMs < 1000L ? 1 : 0) != 0);
        Thread.sleep(2000L);
        HRegionLocation loc = (HRegionLocation)LOCATOR.getRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, TimeUnit.MILLISECONDS.toNanos(500L)).get();
        Assert.assertEquals((Object)loc.getServerName(), (Object)TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName());
    }

    static {
        SLEEP_MS = 0L;
    }

    public static class SleepRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            if (SLEEP_MS > 0L) {
                Threads.sleepWithoutInterrupt((long)SLEEP_MS);
            }
        }
    }
}

