/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestHbck {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHbck.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHbck.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Admin admin;
    private Hbck hbck;
    @Rule
    public TestName name = new TestName();
    private static final TableName tableName = TableName.valueOf((String)TestHbck.class.getSimpleName());

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.createTable(tableName, "family1");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        this.hbck = TEST_UTIL.getHbck();
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : this.admin.listTables()) {
            TEST_UTIL.deleteTable(htd.getTableName());
        }
        this.hbck.close();
    }

    @Test
    public void testSetTableStateInMeta() throws IOException {
        this.hbck.setTableStateInMeta(new TableState(tableName, TableState.State.DISABLED));
        TableState prevState = this.hbck.setTableStateInMeta(new TableState(tableName, TableState.State.ENABLED));
        TestCase.assertTrue((String)("Incorrect previous state! expeced=DISABLED, found=" + prevState.getState()), (boolean)prevState.isDisabled());
    }
}

