/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class, ClientTests.class})
public class TestRestoreSnapshotFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRestoreSnapshotFromClient.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected final byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected final byte[] TEST_FAMILY2 = Bytes.toBytes((String)"cf2");
    protected TableName tableName;
    protected byte[] emptySnapshot;
    protected byte[] snapshotName0;
    protected byte[] snapshotName1;
    protected byte[] snapshotName2;
    protected int snapshot0Rows;
    protected int snapshot1Rows;
    protected Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestRestoreSnapshotFromClient.setupConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
    }

    protected static void setupConf(Configuration conf) {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)(this.name.getMethodName() + "-" + tid));
        this.emptySnapshot = Bytes.toBytes((String)("emptySnaptb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        this.createTable();
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableName);){
            this.snapshot0Rows = this.countRows(table, new byte[0][]);
        }
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName0, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        table = TEST_UTIL.getConnection().getTable(this.tableName);
        var4_3 = null;
        try {
            this.snapshot1Rows = this.countRows(table, new byte[0][]);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var4_3 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
    }

    protected void createTable() throws Exception {
        SnapshotTestingUtils.createTable(TEST_UTIL, this.tableName, this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots(TEST_UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    @Test
    public void testRestoreSnapshot() throws IOException {
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName1, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.emptySnapshot);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, 0L);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        TEST_UTIL.deleteTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
    }

    protected int getNumReplicas() {
        return 1;
    }

    protected HColumnDescriptor getTestRestoreSchemaChangeHCD() {
        return new HColumnDescriptor(this.TEST_FAMILY2);
    }

    @Test
    public void testRestoreSchemaChange() throws Exception {
        Table table = TEST_UTIL.getConnection().getTable(this.tableName);
        this.admin.disableTable(this.tableName);
        this.admin.addColumnFamily(this.tableName, (ColumnFamilyDescriptor)this.getTestRestoreSchemaChangeHCD());
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)2L, (long)table.getTableDescriptor().getFamilies().size());
        HTableDescriptor htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getFamilies().size());
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.TEST_FAMILY2});
        long snapshot2Rows = (long)this.snapshot1Rows + 500L;
        Assert.assertEquals((long)snapshot2Rows, (long)this.countRows(table, new byte[0][]));
        Assert.assertEquals((long)500L, (long)this.countRows(table, new byte[][]{this.TEST_FAMILY2}));
        Set<String> fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName2, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)1L, (long)table.getTableDescriptor().getFamilies().size());
        try {
            this.countRows(table, new byte[][]{this.TEST_FAMILY2});
            Assert.fail((String)("family '" + Bytes.toString((byte[])this.TEST_FAMILY2) + "' should not exists"));
        }
        catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
            // empty catch block
        }
        Assert.assertEquals((long)this.snapshot0Rows, (long)this.countRows(table, new byte[0][]));
        htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)1L, (long)htd.getFamilies().size());
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)1L, (long)fsFamilies.size());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName2);
        this.admin.enableTable(this.tableName);
        htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getFamilies().size());
        Assert.assertEquals((long)2L, (long)table.getTableDescriptor().getFamilies().size());
        Assert.assertEquals((long)500L, (long)this.countRows(table, new byte[][]{this.TEST_FAMILY2}));
        Assert.assertEquals((long)snapshot2Rows, (long)this.countRows(table, new byte[0][]));
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        table.close();
    }

    @Test
    public void testCloneSnapshotOfCloned() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.name.getMethodName() + "-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(clonedTableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(clonedTableName);
        this.admin.snapshot(this.snapshotName2, clonedTableName);
        TEST_UTIL.deleteTable(clonedTableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(clonedTableName, this.admin, this.getNumReplicas());
        TEST_UTIL.deleteTable(clonedTableName);
    }

    @Test
    public void testCloneAndRestoreSnapshot() throws IOException, InterruptedException {
        TEST_UTIL.deleteTable(this.tableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName0, this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.waitCleanerRun();
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
    }

    @Test
    public void testCorruptedSnapshot() throws IOException, InterruptedException {
        SnapshotTestingUtils.corruptSnapshot(TEST_UTIL, Bytes.toString((byte[])this.snapshotName0));
        TableName cloneName = TableName.valueOf((String)(this.name.getMethodName() + "-" + System.currentTimeMillis()));
        try {
            this.admin.cloneSnapshot(this.snapshotName0, cloneName);
            Assert.fail((String)"Expected CorruptedSnapshotException, got succeeded cloneSnapshot()");
        }
        catch (CorruptedSnapshotException e) {
            Assert.assertFalse((boolean)this.admin.tableExists(cloneName));
        }
        catch (Exception e) {
            Assert.fail((String)("Expected CorruptedSnapshotException got: " + e));
        }
    }

    @Test
    public void testRestoreSnapshotAfterSplittingRegions() throws IOException, InterruptedException {
        List regionInfos = this.admin.getRegions(this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regionInfos);
        this.splitRegion((RegionInfo)regionInfos.get(0));
        this.admin.snapshot(this.snapshotName1, this.tableName);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
    }

    private void waitCleanerRun() throws InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
    }

    private Set<String> getFamiliesFromFS(TableName tableName) throws IOException {
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        HashSet<String> families = new HashSet<String>();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)mfs.getFileSystem(), (Path)tableDir)) {
            for (Path familyDir : FSUtils.getFamilyDirs((FileSystem)mfs.getFileSystem(), (Path)regionDir)) {
                families.add(familyDir.getName());
            }
        }
        return families;
    }

    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        SnapshotTestingUtils.verifyRowCount(util, tableName, expectedRows);
    }

    protected int countRows(Table table, byte[] ... families) throws IOException {
        return TEST_UTIL.countRows(table, families);
    }

    protected void splitRegion(RegionInfo regionInfo) throws IOException {
        byte[][] splitPoints = Bytes.split((byte[])regionInfo.getStartKey(), (byte[])regionInfo.getEndKey(), (int)1);
        this.admin.split(regionInfo.getTable(), splitPoints[1]);
    }
}

