/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, LargeTests.class})
public class TestCacheOnWrite {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCacheOnWrite.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCacheOnWrite.class);
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private Configuration conf;
    private CacheConfig cacheConf;
    private FileSystem fs;
    private Random rand = new Random(12983177L);
    private Path storeFilePath;
    private BlockCache blockCache;
    private String testDescription;
    private final CacheOnWriteType cowType;
    private final Compression.Algorithm compress;
    private final boolean cacheCompressedData;
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final int NUM_KV = 25000;
    private static final int INDEX_BLOCK_SIZE = 512;
    private static final int BLOOM_BLOCK_SIZE = 4096;
    private static final BloomType BLOOM_TYPE = BloomType.ROWCOL;
    private static final int CKBYTES = 512;
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;

    public TestCacheOnWrite(CacheOnWriteType cowType, Compression.Algorithm compress, boolean cacheCompressedData, BlockCache blockCache) {
        this.cowType = cowType;
        this.compress = compress;
        this.cacheCompressedData = cacheCompressedData;
        this.blockCache = blockCache;
        this.testDescription = "[cacheOnWrite=" + (Object)((Object)cowType) + ", compress=" + compress + ", cacheCompressedData=" + cacheCompressedData + "]";
        LOG.info(this.testDescription);
    }

    private static List<BlockCache> getBlockCaches() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        ArrayList<BlockCache> blockcaches = new ArrayList<BlockCache>();
        blockcaches.add(new CacheConfig(conf).getBlockCache());
        TEST_UTIL.getConfiguration().setFloat("hbase.lru.blockcache.hard.capacity.limit.factor", 2.0f);
        LruBlockCache lru = new LruBlockCache(0x8000000L, 65536L, TEST_UTIL.getConfiguration());
        blockcaches.add((BlockCache)lru);
        FileSystem.get((Configuration)conf).mkdirs(TEST_UTIL.getDataTestDir());
        int[] bucketSizes = new int[]{512, 2048, 4096, 65536, 131072};
        BucketCache bucketcache = new BucketCache("offheap", 0x8000000L, 65536, bucketSizes, 5, 6400, null);
        blockcaches.add((BlockCache)bucketcache);
        return blockcaches;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() throws IOException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (BlockCache blockCache : TestCacheOnWrite.getBlockCaches()) {
            for (CacheOnWriteType cowType : CacheOnWriteType.values()) {
                for (Compression.Algorithm compress : HBaseCommonTestingUtility.COMPRESSION_ALGORITHMS) {
                    for (boolean cacheCompressedData : new boolean[]{false, true}) {
                        params.add(new Object[]{cowType, compress, cacheCompressedData, blockCache});
                    }
                }
            }
        }
        return params;
    }

    private void clearBlockCache(BlockCache blockCache) throws InterruptedException {
        if (blockCache instanceof LruBlockCache) {
            ((LruBlockCache)blockCache).clearCache();
        } else {
            int clearCount = 0;
            while (blockCache.getBlockCount() > 0L) {
                if (clearCount > 0) {
                    LOG.warn("clear block cache " + blockCache + " " + clearCount + " times, " + blockCache.getBlockCount() + " blocks remaining");
                    Thread.sleep(10L);
                }
                for (CachedBlock block : Lists.newArrayList((Iterable)blockCache)) {
                    BlockCacheKey key = new BlockCacheKey(block.getFilename(), block.getOffset());
                    int evictCount = 0;
                    while (blockCache.evictBlock(key)) {
                        if (evictCount > 1) {
                            LOG.warn("evict block " + block + " in " + blockCache + " " + evictCount + " times, maybe a bug here");
                        }
                        ++evictCount;
                    }
                }
                ++clearCount;
            }
        }
    }

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.set("dfs.datanode.data.dir.perm", "700");
        this.conf.setInt("hfile.index.block.max.size", 512);
        this.conf.setInt("io.storefile.bloom.block.size", 4096);
        this.conf.setBoolean("hbase.block.data.cachecompressed", this.cacheCompressedData);
        this.cowType.modifyConf(this.conf);
        this.fs = HFileSystem.get((Configuration)this.conf);
        CacheConfig.GLOBAL_BLOCK_CACHE_INSTANCE = this.blockCache;
        this.cacheConf = new CacheConfig(this.blockCache, true, true, this.cowType.shouldBeCached(BlockType.DATA), this.cowType.shouldBeCached(BlockType.LEAF_INDEX), this.cowType.shouldBeCached(BlockType.BLOOM_CHUNK), false, this.cacheCompressedData, false, false);
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.clearBlockCache(this.blockCache);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
    }

    private void testStoreFileCacheOnWriteInternals(boolean useTags) throws IOException {
        this.writeStoreFile(useTags);
        this.readStoreFile(useTags);
    }

    private void readStoreFile(boolean useTags) throws IOException {
        HFileBlock block;
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)this.storeFilePath, (CacheConfig)this.cacheConf, (boolean)true, (Configuration)this.conf);
        LOG.info("HFile information: " + reader);
        HFileContext meta = new HFileContextBuilder().withCompression(this.compress).withBytesPerCheckSum(512).withChecksumType(ChecksumType.NULL).withBlockSize(2048).withDataBlockEncoding(NoOpDataBlockEncoder.INSTANCE.getDataBlockEncoding()).withIncludesTags(useTags).build();
        boolean cacheBlocks = false;
        boolean pread = false;
        HFileScanner scanner = reader.getScanner(false, false);
        Assert.assertTrue((String)this.testDescription, (boolean)scanner.seekTo());
        EnumMap<BlockType, Integer> blockCountByType = new EnumMap<BlockType, Integer>(BlockType.class);
        DataBlockEncoding encodingInCache = NoOpDataBlockEncoder.INSTANCE.getDataBlockEncoding();
        ArrayList<Long> cachedBlocksOffset = new ArrayList<Long>();
        HashMap<Long, HFileBlock> cachedBlocks = new HashMap<Long, HFileBlock>();
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            Integer count;
            BlockType bt;
            block = reader.readBlock(offset, -1L, false, true, false, true, null, encodingInCache);
            BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
            HFileBlock fromCache = (HFileBlock)this.blockCache.getBlock(blockCacheKey, true, false, true);
            boolean isCached = fromCache != null;
            cachedBlocksOffset.add(offset);
            cachedBlocks.put(offset, fromCache);
            boolean shouldBeCached = this.cowType.shouldBeCached(block.getBlockType());
            Assert.assertTrue((String)("shouldBeCached: " + shouldBeCached + "\nisCached: " + isCached + "\nTest description: " + this.testDescription + "\nblock: " + block + "\nencodingInCache: " + encodingInCache + "\nblockCacheKey: " + blockCacheKey), (shouldBeCached == isCached ? 1 : 0) != 0);
            if (isCached) {
                if (this.cacheConf.shouldCacheCompressed(fromCache.getBlockType().getCategory())) {
                    if (this.compress != Compression.Algorithm.NONE) {
                        Assert.assertFalse((boolean)fromCache.isUnpacked());
                    }
                    fromCache = fromCache.unpack(meta, reader.getUncachedBlockReader());
                } else {
                    Assert.assertTrue((boolean)fromCache.isUnpacked());
                }
                Assert.assertEquals((long)block.getChecksumType(), (long)fromCache.getChecksumType());
                Assert.assertEquals((Object)block.getBlockType(), (Object)fromCache.getBlockType());
                Assert.assertNotEquals((Object)BlockType.ENCODED_DATA, (Object)block.getBlockType());
                Assert.assertEquals((long)block.getOnDiskSizeWithHeader(), (long)fromCache.getOnDiskSizeWithHeader());
                Assert.assertEquals((long)block.getOnDiskSizeWithoutHeader(), (long)fromCache.getOnDiskSizeWithoutHeader());
                Assert.assertEquals((long)block.getUncompressedSizeWithoutHeader(), (long)fromCache.getUncompressedSizeWithoutHeader());
            }
            blockCountByType.put(bt, ((count = (Integer)blockCountByType.get(bt = block.getBlockType())) == null ? 0 : count) + 1);
        }
        LOG.info("Block count by type: " + blockCountByType);
        String countByType = blockCountByType.toString();
        if (useTags) {
            Assert.assertEquals((Object)("{" + BlockType.DATA + "=2663, LEAF_INDEX=297, BLOOM_CHUNK=9, INTERMEDIATE_INDEX=32}"), (Object)countByType);
        } else {
            Assert.assertEquals((Object)("{" + BlockType.DATA + "=2498, LEAF_INDEX=278, BLOOM_CHUNK=9, INTERMEDIATE_INDEX=31}"), (Object)countByType);
        }
        while (scanner.next()) {
            scanner.getCell();
        }
        for (Long entry : cachedBlocksOffset) {
            BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), entry.longValue());
            HFileBlock hFileBlock = (HFileBlock)cachedBlocks.get(entry);
            if (hFileBlock == null) continue;
            this.blockCache.returnBlock(blockCacheKey, (Cacheable)hFileBlock);
            if (this.cacheCompressedData) {
                if (this.compress != Compression.Algorithm.NONE && this.cowType != CacheOnWriteType.INDEX_BLOCKS && this.cowType != CacheOnWriteType.BLOOM_BLOCKS) continue;
                this.blockCache.returnBlock(blockCacheKey, (Cacheable)hFileBlock);
                continue;
            }
            this.blockCache.returnBlock(blockCacheKey, (Cacheable)hFileBlock);
        }
        scanner.shipped();
        reader.close();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private void writeStoreFile(boolean useTags) throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), "test_cache_on_write");
        HFileContext meta = new HFileContextBuilder().withCompression(this.compress).withBytesPerCheckSum(512).withChecksumType(ChecksumType.NULL).withBlockSize(2048).withDataBlockEncoding(NoOpDataBlockEncoder.INSTANCE.getDataBlockEncoding()).withIncludesTags(useTags).build();
        StoreFileWriter sfw = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withOutputDir(storeFileParentDir).withComparator((CellComparator)CellComparatorImpl.COMPARATOR).withFileContext(meta).withBloomType(BLOOM_TYPE).withMaxKeyCount(25000L).build();
        byte[] cf = Bytes.toBytes((String)"fam");
        for (int i = 0; i < 25000; ++i) {
            KeyValue kv;
            byte[] row = RandomKeyValueUtil.randomOrderedKey(this.rand, i);
            byte[] qualifier = RandomKeyValueUtil.randomRowOrQualifier(this.rand);
            byte[] value = RandomKeyValueUtil.randomValue(this.rand);
            if (useTags) {
                ArrayBackedTag t = new ArrayBackedTag(1, "visibility");
                ArrayList<ArrayBackedTag> tagList = new ArrayList<ArrayBackedTag>();
                tagList.add(t);
                Tag[] tags = new Tag[]{t};
                kv = new KeyValue(row, 0, row.length, cf, 0, cf.length, qualifier, 0, qualifier.length, this.rand.nextLong(), TestCacheOnWrite.generateKeyType(this.rand), value, 0, value.length, tagList);
            } else {
                kv = new KeyValue(row, 0, row.length, cf, 0, cf.length, qualifier, 0, qualifier.length, this.rand.nextLong(), TestCacheOnWrite.generateKeyType(this.rand), value, 0, value.length);
            }
            sfw.append((Cell)kv);
        }
        sfw.close();
        this.storeFilePath = sfw.getPath();
    }

    private void testNotCachingDataBlocksDuringCompactionInternals(boolean useTags) throws IOException, InterruptedException {
        String table = "CompactionCacheOnWrite";
        String cf = "myCF";
        byte[] cfBytes = Bytes.toBytes((String)"myCF");
        int maxVersions = 3;
        HRegion region = TEST_UTIL.createTestRegion("CompactionCacheOnWrite", (ColumnFamilyDescriptor)new HColumnDescriptor("myCF").setCompressionType(this.compress).setBloomFilterType(BLOOM_TYPE).setMaxVersions(3).setDataBlockEncoding(NoOpDataBlockEncoder.INSTANCE.getDataBlockEncoding()));
        int rowIdx = 0;
        long ts = EnvironmentEdgeManager.currentTime();
        for (int iFile = 0; iFile < 5; ++iFile) {
            for (int iRow = 0; iRow < 500; ++iRow) {
                String rowStr = "" + rowIdx * rowIdx * rowIdx + "row" + iFile + "_" + iRow;
                Put p = new Put(Bytes.toBytes((String)rowStr));
                ++rowIdx;
                for (int iCol = 0; iCol < 10; ++iCol) {
                    String qualStr = "col" + iCol;
                    String valueStr = "value_" + rowStr + "_" + qualStr;
                    for (int iTS = 0; iTS < 5; ++iTS) {
                        if (useTags) {
                            ArrayBackedTag t = new ArrayBackedTag(1, "visibility");
                            Tag[] tags = new Tag[]{t};
                            KeyValue kv = new KeyValue(Bytes.toBytes((String)rowStr), cfBytes, Bytes.toBytes((String)qualStr), Long.MAX_VALUE, Bytes.toBytes((String)valueStr), tags);
                            p.add((Cell)kv);
                            continue;
                        }
                        p.addColumn(cfBytes, Bytes.toBytes((String)qualStr), ts++, Bytes.toBytes((String)valueStr));
                    }
                }
                p.setDurability(Durability.ASYNC_WAL);
                region.put(p);
            }
            region.flush(true);
        }
        this.clearBlockCache(this.blockCache);
        Assert.assertEquals((long)0L, (long)this.blockCache.getBlockCount());
        region.compact(false);
        LOG.debug("compactStores() returned");
        for (CachedBlock block : this.blockCache) {
            Assert.assertNotEquals((Object)BlockType.ENCODED_DATA, (Object)block.getBlockType());
            Assert.assertNotEquals((Object)BlockType.DATA, (Object)block.getBlockType());
        }
        region.close();
    }

    @Test
    public void testStoreFileCacheOnWrite() throws IOException {
        this.testStoreFileCacheOnWriteInternals(false);
        this.testStoreFileCacheOnWriteInternals(true);
    }

    @Test
    public void testNotCachingDataBlocksDuringCompaction() throws IOException, InterruptedException {
        this.testNotCachingDataBlocksDuringCompactionInternals(false);
        this.testNotCachingDataBlocksDuringCompactionInternals(true);
    }

    private static enum CacheOnWriteType {
        DATA_BLOCKS("hbase.rs.cacheblocksonwrite", BlockType.DATA, BlockType.ENCODED_DATA),
        BLOOM_BLOCKS("hfile.block.bloom.cacheonwrite", BlockType.BLOOM_CHUNK),
        INDEX_BLOCKS("hfile.block.index.cacheonwrite", BlockType.LEAF_INDEX, BlockType.INTERMEDIATE_INDEX);

        private final String confKey;
        private final BlockType blockType1;
        private final BlockType blockType2;

        private CacheOnWriteType(String confKey, BlockType blockType) {
            this(confKey, blockType, blockType);
        }

        private CacheOnWriteType(String confKey, BlockType blockType1, BlockType blockType2) {
            this.blockType1 = blockType1;
            this.blockType2 = blockType2;
            this.confKey = confKey;
        }

        public boolean shouldBeCached(BlockType blockType) {
            return blockType == this.blockType1 || blockType == this.blockType2;
        }

        public void modifyConf(Configuration conf) {
            for (CacheOnWriteType cowType : CacheOnWriteType.values()) {
                conf.setBoolean(cowType.confKey, cowType == this);
            }
        }
    }
}

