/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestGetLastFlushedSequenceId {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGetLastFlushedSequenceId.class);
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName(), (String)"test");
    private final byte[] family = Bytes.toBytes((String)"f1");
    private final byte[][] families = new byte[][]{this.family};

    @Before
    public void setUp() throws Exception {
        this.testUtil.getConfiguration().setInt("hbase.regionserver.msginterval", 1000);
        this.testUtil.startMiniCluster(1, 1);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException, InterruptedException {
        this.testUtil.getAdmin().createNamespace(NamespaceDescriptor.create((String)this.tableName.getNamespaceAsString()).build());
        Table table = this.testUtil.createTable(this.tableName, this.families);
        table.put(new Put(Bytes.toBytes((String)"k")).addColumn(this.family, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v")));
        MiniHBaseCluster cluster = this.testUtil.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        Region region = null;
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            Region r;
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator iterator = hrs.getRegions(this.tableName).iterator();
            if (!iterator.hasNext()) continue;
            region = r = (Region)iterator.next();
        }
        Assert.assertNotNull(region);
        Thread.sleep(2000L);
        ClusterStatusProtos.RegionStoreSequenceIds ids = this.testUtil.getHBaseCluster().getMaster().getLastSequenceId(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)-1L, (long)ids.getLastFlushedSequenceId());
        long storeSequenceId = ids.getStoreSequenceId(0).getSequenceId();
        Assert.assertTrue((storeSequenceId > 0L ? 1 : 0) != 0);
        this.testUtil.getAdmin().flush(this.tableName);
        Thread.sleep(2000L);
        ids = this.testUtil.getHBaseCluster().getMaster().getLastSequenceId(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertTrue((String)(ids.getLastFlushedSequenceId() + " > " + storeSequenceId), (ids.getLastFlushedSequenceId() > storeSequenceId ? 1 : 0) != 0);
        Assert.assertEquals((long)ids.getLastFlushedSequenceId(), (long)ids.getStoreSequenceId(0).getSequenceId());
        table.close();
    }
}

