/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.MoveRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hbase.thirdparty.com.google.common.primitives.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestRegionMove2 {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMove2.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMove2.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMoveOfRegionOfflinedPostStart() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] cf = org.apache.hadoop.hbase.util.Bytes.toBytes((String)"cf");
        Table t = TEST_UTIL.createMultiRegionTable(tableName, cf, 10);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        HRegionServer rs1 = null;
        HRegionServer rs2 = null;
        List regionsOnRS1ForTable = null;
        try (Admin admin = TEST_UTIL.getAdmin();){
            for (RegionInfo regionInfo2 : admin.getRegions(tableName)) {
                byte[] startKey = regionInfo2.getStartKey();
                byte[] rowKey = Bytes.concat((byte[][])new byte[][]{startKey, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"1")});
                Put p = new Put(rowKey);
                p.addColumn(cf, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"q1"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"value"));
                t.put(p);
            }
            rs1 = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            rs2 = TEST_UTIL.getOtherRegionServer(rs1);
            regionsOnRS1ForTable = admin.getRegions(rs1.getServerName()).stream().filter(regionInfo -> regionInfo.getTable().equals((Object)tableName)).collect(Collectors.toList());
        }
        Assert.assertTrue((String)("Expected to find at least one region for " + tableName + " on " + rs1.getServerName() + ", but found none"), (!regionsOnRS1ForTable.isEmpty() ? 1 : 0) != 0);
        RegionInfo regionToMove = (RegionInfo)regionsOnRS1ForTable.get(0);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        RegionPlan rp = new RegionPlan(regionToMove, rs1.getServerName(), rs2.getServerName());
        MasterProcedureEnv env = (MasterProcedureEnv)master.getMasterProcedureExecutor().getEnvironment();
        HackedMoveRegionProcedure p = new HackedMoveRegionProcedure(env, rp);
        master.getMasterProcedureExecutor().submitProcedure((Procedure)p);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)master.getMasterProcedureExecutor(), (Procedure)p);
        Assert.assertTrue((boolean)HackedMoveRegionProcedure.split.get());
        Assert.assertTrue((rs1.getOnlineRegion(regionToMove.getRegionName()) != null ? 1 : 0) != 0);
    }

    public static class HackedMoveRegionProcedure
    extends MoveRegionProcedure {
        public static AtomicBoolean split = new AtomicBoolean(false);

        public HackedMoveRegionProcedure() {
        }

        public HackedMoveRegionProcedure(MasterProcedureEnv env, RegionPlan plan) throws HBaseIOException {
            super(env, plan, false);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MoveRegionState state) throws InterruptedException {
            StateMachineProcedure.Flow flow = null;
            switch (state) {
                case MOVE_REGION_UNASSIGN: {
                    RegionStates.RegionStateNode rsn = env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
                    rsn.setState(RegionState.State.SPLIT, new RegionState.State[0]);
                    LOG.info("HACKED RSN, setting it to SPLIT: {}", (Object)rsn);
                    split.set(true);
                }
            }
            flow = super.executeFromState(env, state);
            return flow;
        }
    }
}

