/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.FavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.LoadOnlyFavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestFavoredStochasticBalancerPickers
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFavoredStochasticBalancerPickers.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFavoredStochasticBalancerPickers.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int SLAVES = 6;
    private static final int REGIONS = 18;
    private static Configuration conf;
    private Admin admin;
    private MiniHBaseCluster cluster;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.master.loadbalancer.class", LoadOnlyFavoredStochasticBalancer.class, LoadBalancer.class);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 30000L);
        conf.setInt("hbase.master.balancer.stochastic.moveCost", 0);
        conf.setBoolean("hbase.master.balancer.stochastic.execute.maxSteps", true);
        conf.set("hbase.balancer.tablesOnMaster", "none");
    }

    @Before
    public void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(6);
        TEST_UTIL.getDFSCluster().waitClusterUp();
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster(120000L);
        this.cluster = TEST_UTIL.getMiniHBaseCluster();
        this.admin = TEST_UTIL.getAdmin();
        this.admin.setBalancerRunning(false, true);
    }

    @After
    public void stopCluster() throws Exception {
        TEST_UTIL.cleanupTestDir();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPickers() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])HConstants.CATALOG_FAMILY).build();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(columnFamilyDescriptor).build();
        this.admin.createTable(desc, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 18);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        TEST_UTIL.loadTable(this.admin.getConnection().getTable(tableName), HConstants.CATALOG_FAMILY);
        this.admin.flush(tableName);
        HMaster master = this.cluster.getMaster();
        FavoredNodesManager fnm = master.getFavoredNodesManager();
        ServerName masterServerName = master.getServerName();
        ArrayList excludedServers = Lists.newArrayList((Object[])new ServerName[]{masterServerName});
        final ServerName mostLoadedServer = this.getRSWithMaxRegions(tableName, excludedServers);
        Assert.assertNotNull((Object)mostLoadedServer);
        int numRegions = this.getTableRegionsFromServer(tableName, mostLoadedServer).size();
        excludedServers.add(mostLoadedServer);
        ServerName source = this.getRSWithMaxRegions(tableName, excludedServers);
        Assert.assertNotNull((Object)source);
        int regionsToMove = this.getTableRegionsFromServer(tableName, source).size() / 2;
        List<RegionInfo> hris = this.getRegionsThatCanBeMoved(tableName, mostLoadedServer);
        final RegionStates rst = master.getAssignmentManager().getRegionStates();
        for (int i = 0; i < regionsToMove; ++i) {
            final RegionInfo regionInfo = hris.get(i);
            this.admin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)mostLoadedServer.getServerName()));
            LOG.info("Moving region: " + hris.get(i).getRegionNameAsString() + " to " + mostLoadedServer);
            TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return ServerName.isSameAddress((ServerName)rst.getRegionServerOfRegion(regionInfo), (ServerName)mostLoadedServer);
                }
            });
        }
        final int finalRegions = numRegions + regionsToMove;
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                int numRegions = TestFavoredStochasticBalancerPickers.this.getTableRegionsFromServer(tableName, mostLoadedServer).size();
                return numRegions == finalRegions;
            }
        });
        TEST_UTIL.getHBaseCluster().startRegionServerAndWait(60000L);
        HashMap serverAssignments = Maps.newHashMap();
        ClusterMetrics status = this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        for (ServerName sn : status.getLiveServerMetrics().keySet()) {
            if (ServerName.isSameAddress((ServerName)sn, (ServerName)masterServerName)) continue;
            serverAssignments.put(sn, this.getTableRegionsFromServer(tableName, sn));
        }
        RegionLocationFinder regionFinder = new RegionLocationFinder();
        regionFinder.setClusterMetrics(this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)));
        regionFinder.setConf(conf);
        regionFinder.setServices((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster((Map)serverAssignments, null, regionFinder, new RackManager(conf));
        LoadOnlyFavoredStochasticBalancer balancer = (LoadOnlyFavoredStochasticBalancer)TEST_UTIL.getMiniHBaseCluster().getMaster().getLoadBalancer();
        cluster.sortServersByRegionCount();
        Object[] servers = cluster.serverIndicesSortedByRegionCount;
        LOG.info("Servers sorted by region count:" + Arrays.toString(servers));
        LOG.info("Cluster dump: " + cluster);
        if (!mostLoadedServer.equals((Object)cluster.servers[(Integer)servers[servers.length - 1]])) {
            LOG.error("Most loaded server: " + mostLoadedServer + " does not match: " + cluster.servers[(Integer)servers[servers.length - 1]]);
        }
        Assert.assertEquals((Object)mostLoadedServer, (Object)cluster.servers[(Integer)servers[servers.length - 1]]);
        FavoredStochasticBalancer.FavoredNodeLoadPicker loadPicker = new FavoredStochasticBalancer.FavoredNodeLoadPicker((FavoredStochasticBalancer)balancer);
        boolean userRegionPicked = false;
        for (int i = 0; i < 100 && !userRegionPicked; ++i) {
            BaseLoadBalancer.Cluster.Action action = loadPicker.generate(cluster);
            if (action.type != BaseLoadBalancer.Cluster.Action.Type.MOVE_REGION) continue;
            BaseLoadBalancer.Cluster.MoveRegionAction moveRegionAction = (BaseLoadBalancer.Cluster.MoveRegionAction)action;
            RegionInfo region = cluster.regions[moveRegionAction.region];
            Assert.assertNotEquals((long)-1L, (long)moveRegionAction.toServer);
            ServerName destinationServer = cluster.servers[moveRegionAction.toServer];
            Assert.assertEquals((Object)cluster.servers[moveRegionAction.fromServer], (Object)mostLoadedServer);
            if (region.getTable().isSystemTable()) continue;
            List favNodes = fnm.getFavoredNodes(region);
            Assert.assertTrue((boolean)favNodes.contains(ServerName.valueOf((String)destinationServer.getHostAndPort(), (long)-1L)));
            userRegionPicked = true;
        }
        Assert.assertTrue((String)"load picker did not pick expected regions in 100 iterations.", (boolean)userRegionPicked);
    }

    private List<RegionInfo> getRegionsThatCanBeMoved(TableName tableName, ServerName serverName) {
        ArrayList regions = Lists.newArrayList();
        RegionStates rst = this.cluster.getMaster().getAssignmentManager().getRegionStates();
        FavoredNodesManager fnm = this.cluster.getMaster().getFavoredNodesManager();
        for (RegionInfo regionInfo : fnm.getRegionsOfFavoredNode(serverName)) {
            if (!regionInfo.getTable().equals((Object)tableName) || ServerName.isSameAddress((ServerName)rst.getRegionServerOfRegion(regionInfo), (ServerName)serverName)) continue;
            regions.add(regionInfo);
        }
        return regions;
    }

    private List<RegionInfo> getTableRegionsFromServer(TableName tableName, ServerName source) throws IOException {
        ArrayList regionInfos = Lists.newArrayList();
        HRegionServer regionServer = this.cluster.getRegionServer(source);
        for (Region region : regionServer.getRegions(tableName)) {
            regionInfos.add(region.getRegionInfo());
        }
        return regionInfos;
    }

    private ServerName getRSWithMaxRegions(TableName tableName, List<ServerName> excludeNodes) throws IOException {
        int maxRegions = 0;
        ServerName maxLoadedServer = null;
        for (JVMClusterUtil.RegionServerThread rst : this.cluster.getLiveRegionServerThreads()) {
            List regions = rst.getRegionServer().getRegions(tableName);
            LOG.debug("Server: " + rst.getRegionServer().getServerName() + " regions: " + regions.size());
            if (regions.size() <= maxRegions || excludeNodes != null && this.doesMatchExcludeNodes(excludeNodes, rst.getRegionServer().getServerName())) continue;
            maxRegions = regions.size();
            maxLoadedServer = rst.getRegionServer().getServerName();
        }
        return maxLoadedServer;
    }

    private boolean doesMatchExcludeNodes(List<ServerName> excludeNodes, ServerName sn) {
        for (ServerName excludeSN : excludeNodes) {
            if (!ServerName.isSameAddress((ServerName)sn, (ServerName)excludeSN)) continue;
            return true;
        }
        return false;
    }
}

