/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.TestCreateTableProcedure;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterProcedureEvents {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterProcedureEvents.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCreateTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setBoolean("hbase.procedure.store.wal.use.hsync", false);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestMasterProcedureEvents.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        UTIL.waitUntilNoRegionsInTransition();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor htd : UTIL.getAdmin().listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testMasterInitializedEvent() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        while (!master.isInitialized()) {
            Thread.sleep(250L);
        }
        master.setInitialized(false);
        this.testProcedureEventWaitWake(master, master.getInitializedEvent(), (Procedure<MasterProcedureEnv>)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, new RegionInfo[]{hri}));
    }

    private void testProcedureEventWaitWake(HMaster master, ProcedureEvent<?> event, Procedure<MasterProcedureEnv> proc) throws Exception {
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        MasterProcedureScheduler procSched = ((MasterProcedureEnv)procExec.getEnvironment()).getProcedureScheduler();
        long startPollCalls = procSched.getPollCalls();
        long startNullPollCalls = procSched.getNullPollCalls();
        LOG.debug("checking " + event);
        Assert.assertEquals((Object)false, (Object)event.isReady());
        Assert.assertEquals((long)0L, (long)event.getSuspendedProcedures().size());
        LOG.debug("submit " + proc);
        long procId = procExec.submitProcedure(proc);
        LOG.debug("wait procedure suspended on " + event);
        while (event.getSuspendedProcedures().size() < 1) {
            Thread.sleep(25L);
        }
        LOG.debug("checking " + event + " size=" + event.getSuspendedProcedures().size());
        Assert.assertEquals((Object)false, (Object)event.isReady());
        Assert.assertEquals((long)1L, (long)event.getSuspendedProcedures().size());
        LOG.debug("wake " + event);
        event.wake((AbstractProcedureScheduler)procSched);
        Assert.assertEquals((Object)true, (Object)event.isReady());
        LOG.debug("waiting " + proc);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Assert.assertEquals((Object)true, (Object)event.isReady());
        Assert.assertEquals((long)0L, (long)event.getSuspendedProcedures().size());
        LOG.debug("completed execution of " + proc + " pollCalls=" + (procSched.getPollCalls() - startPollCalls) + " nullPollCalls=" + (procSched.getNullPollCalls() - startNullPollCalls));
    }
}

