/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTruncateTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTruncateTableProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTruncateTableProcedure.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testTruncateNotExistentTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        Throwable cause = null;
        try {
            long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
            Procedure result = procExec.getResult(procId);
            Assert.assertTrue((boolean)result.isFailed());
            cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
        }
        catch (Throwable t) {
            cause = t;
        }
        LOG.debug("Truncate failed with exception: " + cause);
        Assert.assertTrue((boolean)(cause instanceof TableNotFoundException));
    }

    @Test
    public void testTruncateNotDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        Throwable cause = null;
        try {
            long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
            Procedure result = procExec.getResult(procId);
            Assert.assertTrue((boolean)result.isFailed());
            cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
        }
        catch (Throwable t) {
            cause = t;
        }
        LOG.debug("Truncate failed with exception: " + cause);
        Assert.assertTrue((boolean)(cause instanceof TableNotDisabledException));
    }

    @Test
    public void testSimpleTruncatePreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testSimpleTruncate(tableName, true);
    }

    @Test
    public void testSimpleTruncateNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testSimpleTruncate(tableName, false);
    }

    private void testSimpleTruncate(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getAdmin().getTableRegions(tableName).toArray(new RegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    @Test
    public void testRecoveryAndDoubleExecutionPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testRecoveryAndDoubleExecution(tableName, true);
    }

    @Test
    public void testRecoveryAndDoubleExecutionNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testRecoveryAndDoubleExecution(tableName, false);
    }

    private void testRecoveryAndDoubleExecution(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getAdmin().getTableRegions(tableName).toArray(new RegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    @Test
    public void testOnHDFSFailurePreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testOnHDFSFailure(tableName, true);
    }

    @Test
    public void testOnHDFSFailureNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testOnHDFSFailure(tableName, false);
    }

    private void testOnHDFSFailure(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedureOnHDFSFailure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    @Test
    public void testTruncateWithPreserveAfterSplit() throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        this.splitAndTruncate(tableName, regions, 1);
    }

    @Test
    public void testTruncatePreserveWithReplicaRegionAfterSplit() throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(3).setColumnFamilies((Collection)Arrays.stream(families).map(fam -> ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)fam)).build()).collect(Collectors.toList())).build();
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])splitKeys);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        this.splitAndTruncate(tableName, regions, 3);
    }

    private void splitAndTruncate(TableName tableName, RegionInfo[] regions, int regionReplication) throws IOException, InterruptedException {
        UTIL.getAdmin().split(tableName, new byte[]{48});
        UTIL.waitFor(60000L, () -> UTIL.getAdmin().getRegions(tableName).size() > regions.length * regionReplication);
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        Assert.assertEquals((long)((regions.length + 1) * regionReplication), (long)UTIL.getAdmin().getRegions(tableName).size());
    }

    public static class TruncateTableProcedureOnHDFSFailure
    extends TruncateTableProcedure {
        private boolean failOnce = false;

        public TruncateTableProcedureOnHDFSFailure() {
        }

        public TruncateTableProcedureOnHDFSFailure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits) throws HBaseIOException {
            super(env, tableName, preserveSplits);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) throws InterruptedException {
            if (!this.failOnce && state == MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CREATE_FS_LAYOUT) {
                try {
                    RegionInfo regionInfo = this.getFirstRegionInfo();
                    Configuration conf = env.getMasterConfiguration();
                    MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
                    Path tempdir = mfs.getTempDir();
                    Path tableDir = FSUtils.getTableDir((Path)tempdir, (TableName)regionInfo.getTable());
                    Path regionDir = FSUtils.getRegionDir((Path)tableDir, (RegionInfo)regionInfo);
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    fs.mkdirs(regionDir);
                    this.failOnce = true;
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                catch (IOException e) {
                    Assert.fail((String)("failed to create a region directory: " + e));
                }
            }
            return super.executeFromState(env, state);
        }
    }
}

