/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionServerAccounting {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerAccounting.class);

    @Test
    public void testOnheapMemstoreHigherWaterMarkLimits() {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.2f);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0xC0000000L, 0x40000000L, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_HIGHER_MARK, (Object)regionServerAccounting.isAboveHighWaterMark());
    }

    @Test
    public void testOnheapMemstoreLowerWaterMarkLimits() {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.2f);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0xC0000000L, 0x40000000L, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_LOWER_MARK, (Object)regionServerAccounting.isAboveLowWaterMark());
    }

    @Test
    public void testOffheapMemstoreHigherWaterMarkLimitsDueToDataSize() {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0xC0000000L, 0L, 0x40000000L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_OFFHEAP_HIGHER_MARK, (Object)regionServerAccounting.isAboveHighWaterMark());
    }

    @Test
    public void testOffheapMemstoreHigherWaterMarkLimitsDueToHeapSize() {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.2f);
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0x300000L, 0x80000000L, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_HIGHER_MARK, (Object)regionServerAccounting.isAboveHighWaterMark());
    }

    @Test
    public void testOffheapMemstoreLowerWaterMarkLimitsDueToDataSize() {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0xC0000000L, 0L, 0x40000000L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_OFFHEAP_LOWER_MARK, (Object)regionServerAccounting.isAboveLowWaterMark());
    }

    @Test
    public void testOffheapMemstoreLowerWaterMarkLimitsDueToHeapSize() {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.2f);
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0x300000L, 0x80000000L, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_LOWER_MARK, (Object)regionServerAccounting.isAboveLowWaterMark());
    }
}

