/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.DamagedWALException;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALLockup {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALLockup.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALLockup.class);
    @Rule
    public TestName name = new TestName();
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    HRegion region = null;
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration CONF;
    private String dir;
    protected TableName tableName;

    @Before
    public void setup() throws IOException {
        CONF = TEST_UTIL.getConfiguration();
        CONF.setFloat("hfile.block.cache.size", 0.0f);
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info("Cleaning test directory: " + TEST_UTIL.getDataTestDir());
        TEST_UTIL.cleanupTestDir();
    }

    private String getName() {
        return this.name.getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockupWhenSyncInMiddleOfZigZagSetup() throws IOException {
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)server.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)server.isAborted()).thenReturn((Object)false);
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        DodgyFSLog dodgyWAL = new DodgyFSLog(fs, rootDir, this.getName(), CONF);
        Path originalWAL = dodgyWAL.getCurrentFileName();
        LogRoller logRoller = new LogRoller(server, services);
        logRoller.addWAL((WAL)dodgyWAL);
        logRoller.start();
        final HRegion region = TestWALLockup.initHRegion(this.tableName, null, null, (WAL)dodgyWAL);
        byte[] bytes = Bytes.toBytes((String)this.getName());
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(COLUMN_FAMILY_BYTES, 0);
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        try {
            Put put = new Put(bytes);
            put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
            WALKeyImpl key = new WALKeyImpl(region.getRegionInfo().getEncodedNameAsBytes(), TableName.META_TABLE_NAME, System.currentTimeMillis(), mvcc, scopes);
            WALEdit edit = new WALEdit();
            CellScanner CellScanner2 = put.cellScanner();
            Assert.assertTrue((boolean)CellScanner2.advance());
            edit.add(CellScanner2.current());
            for (int i = 0; i < 1000; ++i) {
                region.put(put);
            }
            LOG.info("SET throwing of exception on append");
            dodgyWAL.throwException = true;
            dodgyWAL.append(region.getRegionInfo(), key, edit, true);
            boolean exception = false;
            try {
                dodgyWAL.sync();
            }
            catch (Exception e) {
                exception = true;
            }
            Assert.assertTrue((String)"Did not get sync exception", (boolean)exception);
            Thread t = new Thread("Flusher"){

                @Override
                public void run() {
                    try {
                        if (region.getMemStoreDataSize() <= 0L) {
                            throw new IOException("memstore size=" + region.getMemStoreDataSize());
                        }
                        region.flush(false);
                    }
                    catch (IOException e) {
                        LOG.info("In flush", (Throwable)e);
                    }
                    LOG.info("Exiting");
                }
            };
            t.setDaemon(true);
            t.start();
            while (dodgyWAL.latch.getCount() > 0L) {
                Threads.sleep((long)1L);
            }
            Assert.assertTrue((originalWAL != dodgyWAL.getCurrentFileName() ? 1 : 0) != 0);
            dodgyWAL.throwException = false;
            try {
                region.put(put);
            }
            catch (Exception e) {
                LOG.info("In the put", (Throwable)e);
            }
        }
        finally {
            Mockito.when((Object)server.isStopped()).thenReturn((Object)true);
            Closeables.close((Closeable)logRoller, (boolean)true);
            try {
                if (region != null) {
                    region.close();
                }
                if (dodgyWAL != null) {
                    dodgyWAL.close();
                }
            }
            catch (Exception e) {
                LOG.info("On way out", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRingBufferEventHandlerStuckWhenSyncFailed() throws IOException, InterruptedException {
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)server.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)server.isAborted()).thenReturn((Object)false);
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        class DodgyFSLog
        extends FSHLog {
            private volatile boolean zigZagCreated;

            public DodgyFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
                this.zigZagCreated = false;
            }

            protected void afterCreatingZigZagLatch() {
                this.zigZagCreated = true;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            protected long getSequenceOnRingBuffer() {
                return super.getSequenceOnRingBuffer();
            }

            protected void publishSyncOnRingBufferAndBlock(long sequence) {
                try {
                    super.blockOnSync(super.publishSyncOnRingBuffer(sequence));
                    Assert.fail((String)"Expect an IOException here.");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
                final WALProvider.Writer w = super.createWriterInstance(path);
                return new WALProvider.Writer(){

                    public void close() throws IOException {
                        w.close();
                    }

                    public void sync() throws IOException {
                        throw new IOException("FAKE! Failed to replace a bad datanode...SYNC");
                    }

                    public void append(WAL.Entry entry) throws IOException {
                        w.append(entry);
                    }

                    public long getLength() {
                        return w.getLength();
                    }
                };
            }
        }
        final DodgyFSLog dodgyWAL = new DodgyFSLog(fs, rootDir, this.getName(), CONF);
        LogRoller logRoller = new LogRoller(server, services);
        logRoller.addWAL((WAL)dodgyWAL);
        logRoller.start();
        try {
            final long seqForSync = dodgyWAL.getSequenceOnRingBuffer();
            LOG.info("Trigger log roll for creating a ZigZagLatch.");
            logRoller.requestRollAll();
            while (!dodgyWAL.zigZagCreated) {
                Thread.sleep(10L);
            }
            LOG.info("Send sync for RingBufferEventHandler");
            Thread syncThread = new Thread(){
                {
                }

                @Override
                public void run() {
                    dodgyWAL.publishSyncOnRingBufferAndBlock(seqForSync);
                }
            };
            syncThread.start();
            syncThread.join();
            try {
                LOG.info("Call sync for testing whether RingBufferEventHandler is hanging.");
                dodgyWAL.sync();
                Assert.fail((String)"Expect an IOException here.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            Mockito.when((Object)server.isStopped()).thenReturn((Object)true);
            if (logRoller != null) {
                logRoller.interrupt();
            }
            if (dodgyWAL != null) {
                dodgyWAL.close();
            }
        }
    }

    private static HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, WAL wal) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, false, Durability.SYNC_WAL, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }

    static class DummyWALActionsListener
    implements WALActionsListener {
        DummyWALActionsListener() {
        }

        public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
            if (logKey.getTableName().getNameAsString().equalsIgnoreCase("sleep")) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (logKey.getTableName().getNameAsString().equalsIgnoreCase("DamagedWALException")) {
                throw new DamagedWALException("Failed appending");
            }
        }
    }

    static class DummyServer
    implements Server {
        private Configuration conf;
        private String serverName;
        private boolean isAborted = false;

        public DummyServer(Configuration conf, String serverName) {
            this.conf = conf;
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ZKWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            LOG.info("Aborting " + this.serverName);
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isAborted = true;
        }

        public boolean isStopped() {
            return this.isAborted;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }

    private static final class DodgyFSLog
    extends FSHLog {
        volatile boolean throwException = false;
        CountDownLatch latch = new CountDownLatch(1);

        public DodgyFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
            super(fs, root, logDir, conf);
        }

        protected void afterCreatingZigZagLatch() {
            if (this.throwException) {
                try {
                    LOG.info("LATCHED");
                    if (!this.latch.await(5L, TimeUnit.SECONDS)) {
                        LOG.warn("GIVE UP! Failed waiting on latch...Test is ABORTED!");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        protected void beforeWaitOnSafePoint() {
            if (this.throwException) {
                LOG.info("COUNTDOWN");
                while (this.latch.getCount() <= 0L) {
                    Threads.sleep((long)1L);
                }
                this.latch.countDown();
            }
        }

        protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
            final WALProvider.Writer w = super.createWriterInstance(path);
            return new WALProvider.Writer(){

                public void close() throws IOException {
                    w.close();
                }

                public void sync() throws IOException {
                    if (throwException) {
                        throw new IOException("FAKE! Failed to replace a bad datanode...SYNC");
                    }
                    w.sync();
                }

                public void append(WAL.Entry entry) throws IOException {
                    if (throwException) {
                        throw new IOException("FAKE! Failed to replace a bad datanode...APPEND");
                    }
                    w.append(entry);
                }

                public long getLength() {
                    return w.getLength();
                }
            };
        }
    }
}

