/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestProtobufLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestAsyncProtobufLog
extends AbstractTestProtobufLog<WALProvider.AsyncWriter> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncProtobufLog.class);
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        AbstractTestProtobufLog.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractTestProtobufLog.tearDownAfterClass();
        EVENT_LOOP_GROUP.shutdownGracefully().syncUninterruptibly();
    }

    @Override
    protected WALProvider.AsyncWriter createWriter(Path path) throws IOException {
        return AsyncFSWALProvider.createAsyncWriter((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)this.fs, (Path)path, (boolean)false, (EventLoopGroup)EVENT_LOOP_GROUP.next(), CHANNEL_CLASS);
    }

    @Override
    protected void append(WALProvider.AsyncWriter writer, WAL.Entry entry) throws IOException {
        writer.append(entry);
    }

    @Override
    protected void sync(WALProvider.AsyncWriter writer) throws IOException {
        try {
            writer.sync().get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new IOException(e.getCause());
        }
    }
}

