/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestNamespaceReplication
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespaceReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNamespaceReplication.class);
    private static String ns1 = "ns1";
    private static String ns2 = "ns2";
    private static final TableName tabAName = TableName.valueOf((String)"ns1:TA");
    private static final TableName tabBName = TableName.valueOf((String)"ns2:TB");
    private static final byte[] f1Name = Bytes.toBytes((String)"f1");
    private static final byte[] f2Name = Bytes.toBytes((String)"f2");
    private static final byte[] val = Bytes.toBytes((String)"myval");
    private static HTableDescriptor tabA;
    private static HTableDescriptor tabB;
    private static Connection connection1;
    private static Connection connection2;
    private static Admin admin1;
    private static Admin admin2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestReplicationBase.setUpBeforeClass();
        connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        admin1 = connection1.getAdmin();
        admin2 = connection2.getAdmin();
        admin1.createNamespace(NamespaceDescriptor.create((String)ns1).build());
        admin1.createNamespace(NamespaceDescriptor.create((String)ns2).build());
        admin2.createNamespace(NamespaceDescriptor.create((String)ns1).build());
        admin2.createNamespace(NamespaceDescriptor.create((String)ns2).build());
        tabA = new HTableDescriptor(tabAName);
        HColumnDescriptor fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        admin1.createTable((TableDescriptor)tabA);
        admin2.createTable((TableDescriptor)tabA);
        tabB = new HTableDescriptor(tabBName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        admin1.createTable((TableDescriptor)tabB);
        admin2.createTable((TableDescriptor)tabB);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        admin1.disableTable(tabAName);
        admin1.deleteTable(tabAName);
        admin1.disableTable(tabBName);
        admin1.deleteTable(tabBName);
        admin2.disableTable(tabAName);
        admin2.deleteTable(tabAName);
        admin2.disableTable(tabBName);
        admin2.deleteTable(tabBName);
        admin1.deleteNamespace(ns1);
        admin1.deleteNamespace(ns2);
        admin2.deleteNamespace(ns1);
        admin2.deleteNamespace(ns2);
        connection1.close();
        connection2.close();
        TestReplicationBase.tearDownAfterClass();
    }

    @Test
    public void testNamespaceReplication() throws Exception {
        Table htab1A = connection1.getTable(tabAName);
        Table htab2A = connection2.getTable(tabAName);
        Table htab1B = connection1.getTable(tabBName);
        Table htab2B = connection2.getTable(tabBName);
        ReplicationPeerConfig rpc = admin.getPeerConfig("2");
        rpc.setReplicateAllUserTables(false);
        admin.updatePeerConfig("2", rpc);
        rpc = admin.getPeerConfig("2");
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        admin.updatePeerConfig("2", rpc);
        LOG.info("update peer config");
        this.put(htab1A, row, f1Name, f2Name);
        this.ensureRowExisted(htab2A, row, f1Name, f2Name);
        this.delete(htab1A, row, f1Name, f2Name);
        this.ensureRowNotExisted(htab2A, row, f1Name, f2Name);
        this.put(htab1B, row, f1Name, f2Name);
        this.ensureRowNotExisted(htab2B, row, f1Name, f2Name);
        rpc = admin.getPeerConfig("2");
        namespaces = new HashSet();
        namespaces.add(ns2);
        rpc.setNamespaces(namespaces);
        HashMap tableCfs = new HashMap();
        tableCfs.put(tabAName, new ArrayList());
        ((List)tableCfs.get(tabAName)).add("f1");
        rpc.setTableCFsMap(tableCfs);
        admin.updatePeerConfig("2", rpc);
        LOG.info("update peer config");
        this.put(htab1A, row, f1Name, f2Name);
        this.ensureRowExisted(htab2A, row, new byte[][]{f1Name});
        this.delete(htab1A, row, f1Name, f2Name);
        this.ensureRowNotExisted(htab2A, row, new byte[][]{f1Name});
        this.put(htab1B, row, f1Name, f2Name);
        this.ensureRowExisted(htab2B, row, f1Name, f2Name);
        this.delete(htab1B, row, f1Name, f2Name);
        this.ensureRowNotExisted(htab2B, row, f1Name, f2Name);
        admin.removePeer("2");
    }

    private void put(Table source, byte[] row, byte[] ... families) throws Exception {
        for (byte[] fam : families) {
            Put put = new Put(row);
            put.addColumn(fam, row, val);
            source.put(put);
        }
    }

    private void delete(Table source, byte[] row, byte[] ... families) throws Exception {
        for (byte[] fam : families) {
            Delete del = new Delete(row);
            del.addFamily(fam);
            source.delete(del);
        }
    }

    private void ensureRowExisted(Table target, byte[] row, byte[] ... families) throws Exception {
        block0: for (byte[] fam : families) {
            Get get = new Get(row);
            get.addFamily(fam);
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for put replication");
                }
                if (!(res = target.get(get)).isEmpty()) {
                    Assert.assertEquals((long)1L, (long)res.size());
                    Assert.assertArrayEquals((byte[])val, (byte[])res.value());
                    continue block0;
                }
                LOG.info("Row not available");
                Thread.sleep(500L);
            }
        }
    }

    private void ensureRowNotExisted(Table target, byte[] row, byte[] ... families) throws Exception {
        block0: for (byte[] fam : families) {
            Get get = new Get(row);
            get.addFamily(fam);
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for delete replication");
                }
                if ((res = target.get(get)).size() < 1) continue block0;
                LOG.info("Row not deleted");
                Thread.sleep(500L);
            }
        }
    }
}

