/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationKillRS
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationKillRS.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationKillRS.class);

    public void loadTableAndKillRS(HBaseTestingUtility util) throws Exception {
        Result[] res;
        int rsToKill1 = util.getHBaseCluster().getServerWithMeta() == 0 ? 1 : 0;
        Thread killer = TestReplicationKillRS.killARegionServer(util, 5000L, rsToKill1);
        LOG.info("Start loading table");
        int initialCount = utility1.loadTable(htable1, famName);
        LOG.info("Done loading table");
        killer.join(5000L);
        LOG.info("Done waiting for threads");
        while (true) {
            try {
                Scan scan = new Scan();
                ResultScanner scanner = htable1.getScanner(scan);
                res = scanner.next(initialCount);
                scanner.close();
            }
            catch (UnknownScannerException ex) {
                LOG.info("Cluster wasn't ready yet, restarting scanner");
                continue;
            }
            break;
        }
        if (res.length != initialCount) {
            LOG.warn("We lost some rows on the master cluster!");
            initialCount = res.length;
        }
        int lastCount = 0;
        long start = System.currentTimeMillis();
        int i = 0;
        while (true) {
            if (i == 9) {
                Assert.fail((String)("Waited too much time for queueFailover replication. Waited " + (System.currentTimeMillis() - start) + "ms."));
            }
            Scan scan2 = new Scan();
            ResultScanner scanner2 = htable2.getScanner(scan2);
            Result[] res2 = scanner2.next(initialCount * 2);
            scanner2.close();
            if (res2.length >= initialCount) break;
            i = lastCount < res2.length ? --i : ++i;
            lastCount = res2.length;
            LOG.info("Only got " + lastCount + " rows instead of " + initialCount + " current i=" + i);
            Thread.sleep(1000L);
        }
    }

    private static Thread killARegionServer(final HBaseTestingUtility utility, final long timeout, final int rs) {
        Thread killer = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    utility.getHBaseCluster().getRegionServer(rs).stop("Stopping as part of the test");
                }
                catch (Exception e) {
                    LOG.error("Couldn't kill a region server", (Throwable)e);
                }
            }
        };
        killer.setDaemon(true);
        killer.start();
        return killer;
    }
}

