/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestTokenAuthentication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTokenAuthentication.class);
    @Parameterized.Parameter(value=0)
    public String rpcServerImpl;
    private HBaseTestingUtility TEST_UTIL;
    private TokenServer server;
    private Thread serverThread;
    private AuthenticationTokenSecretManager secretManager;
    private ClusterId clusterId = new ClusterId();

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({SimpleRpcServer.class.getName()}, {NettyRpcServer.class.getName()});
    }

    @Before
    public void setUp() throws Exception {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.TEST_UTIL.startMiniZKCluster();
        SecurityInfo.addInfo((String)AuthenticationProtos.AuthenticationService.getDescriptor().getName(), (SecurityInfo)new SecurityInfo("hbase.test.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        Configuration conf = this.TEST_UTIL.getConfiguration();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hadoop.security.authorization", true);
        conf.set("hbase.rpc.server.impl", this.rpcServerImpl);
        this.server = new TokenServer(conf, this.TEST_UTIL);
        this.serverThread = new Thread(this.server);
        Threads.setDaemonThreadRunning((Thread)this.serverThread, (String)("TokenServer:" + this.server.getServerName().toString()));
        while (!this.server.isStarted() && !this.server.isStopped()) {
            Thread.sleep(10L);
        }
        this.server.rpcServer.refreshAuthManager(new PolicyProvider(){

            public Service[] getServices() {
                return new Service[]{new Service("security.client.protocol.acl", AuthenticationProtos.AuthenticationService.BlockingInterface.class)};
            }
        });
        ZKClusterId.setClusterId((ZKWatcher)this.server.getZooKeeper(), (ClusterId)this.clusterId);
        this.secretManager = (AuthenticationTokenSecretManager)this.server.getSecretManager();
        while (this.secretManager.getCurrentKey() == null) {
            Thread.sleep(1L);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop("Test complete");
        Threads.shutdown((Thread)this.serverThread);
        this.TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testTokenCreation() throws Exception {
        Token token = this.secretManager.generateToken("testuser");
        AuthenticationTokenIdentifier ident = new AuthenticationTokenIdentifier();
        Writables.getWritable((byte[])token.getIdentifier(), (Writable)ident);
        Assert.assertEquals((String)"Token username should match", (Object)"testuser", (Object)ident.getUsername());
        byte[] passwd = this.secretManager.retrievePassword(ident);
        Assert.assertTrue((String)"Token password and password from secret manager should match", (boolean)Bytes.equals((byte[])token.getPassword(), (byte[])passwd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseExistingToken() throws Exception {
        User user = User.createUserForTesting((Configuration)this.TEST_UTIL.getConfiguration(), (String)"testuser2", (String[])new String[]{"testgroup"});
        Token token = this.secretManager.generateToken(user.getName());
        Assert.assertNotNull((Object)token);
        user.addToken(token);
        Token firstToken = new AuthenticationTokenSelector().selectToken(token.getService(), user.getTokens());
        Assert.assertNotNull((Object)firstToken);
        Assert.assertEquals((Object)token, (Object)firstToken);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());){
            Assert.assertFalse((boolean)TokenUtil.addTokenIfMissing((Connection)conn, (User)user));
            Token secondToken = new AuthenticationTokenSelector().selectToken(token.getService(), user.getTokens());
            Assert.assertEquals((Object)firstToken, (Object)secondToken);
        }
    }

    static {
        System.setProperty("java.security.krb5.realm", "hbase");
        System.setProperty("java.security.krb5.kdc", "blah");
    }

    private static class NonShadedBlockingRpcCallback<R>
    implements RpcCallback<R> {
        private R result;
        private boolean resultSet = false;

        private NonShadedBlockingRpcCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(R parameter) {
            NonShadedBlockingRpcCallback nonShadedBlockingRpcCallback = this;
            synchronized (nonShadedBlockingRpcCallback) {
                this.result = parameter;
                this.resultSet = true;
                this.notifyAll();
            }
        }

        public synchronized R get() throws IOException {
            while (!this.resultSet) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptedIOException exception = new InterruptedIOException(ie.getMessage());
                    exception.initCause(ie);
                    throw exception;
                }
            }
            return this.result;
        }
    }

    private static class TokenServer
    extends TokenProvider
    implements AuthenticationProtos.AuthenticationService.BlockingInterface,
    Runnable,
    Server {
        private static final Logger LOG = LoggerFactory.getLogger(TokenServer.class);
        private Configuration conf;
        private HBaseTestingUtility TEST_UTIL;
        private RpcServerInterface rpcServer;
        private InetSocketAddress isa;
        private ZKWatcher zookeeper;
        private Sleeper sleeper;
        private boolean started = false;
        private boolean aborted = false;
        private boolean stopped = false;
        private long startcode;

        public TokenServer(Configuration conf, HBaseTestingUtility TEST_UTIL) throws IOException {
            this.conf = conf;
            this.TEST_UTIL = TEST_UTIL;
            this.startcode = EnvironmentEdgeManager.currentTime();
            String hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)"default", (String)"default"));
            int port = 0;
            InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
            if (initialIsa.getAddress() == null) {
                throw new IllegalArgumentException("Failed resolve of " + initialIsa);
            }
            ArrayList<RpcServer.BlockingServiceAndInterface> sai = new ArrayList<RpcServer.BlockingServiceAndInterface>(1);
            final BlockingService service = AuthenticationProtos.AuthenticationService.newReflectiveBlockingService((AuthenticationProtos.AuthenticationService.BlockingInterface)this);
            org.apache.hbase.thirdparty.com.google.protobuf.BlockingService proxy = new org.apache.hbase.thirdparty.com.google.protobuf.BlockingService(){

                public org.apache.hbase.thirdparty.com.google.protobuf.Message callBlockingMethod(Descriptors.MethodDescriptor md, org.apache.hbase.thirdparty.com.google.protobuf.RpcController controller, org.apache.hbase.thirdparty.com.google.protobuf.Message param) throws ServiceException {
                    Descriptors.MethodDescriptor methodDescriptor = service.getDescriptorForType().findMethodByName(md.getName());
                    Message request = service.getRequestPrototype(methodDescriptor);
                    Message response = null;
                    try {
                        response = service.callBlockingMethod(methodDescriptor, null, request);
                    }
                    catch (com.google.protobuf.ServiceException e) {
                        throw new ServiceException((Throwable)e);
                    }
                    return null;
                }

                public Descriptors.ServiceDescriptor getDescriptorForType() {
                    return null;
                }

                public org.apache.hbase.thirdparty.com.google.protobuf.Message getRequestPrototype(Descriptors.MethodDescriptor arg0) {
                    return null;
                }

                public org.apache.hbase.thirdparty.com.google.protobuf.Message getResponsePrototype(Descriptors.MethodDescriptor arg0) {
                    return null;
                }
            };
            sai.add(new RpcServer.BlockingServiceAndInterface(proxy, AuthenticationProtos.AuthenticationService.BlockingInterface.class));
            this.rpcServer = RpcServerFactory.createRpcServer((Server)this, (String)"tokenServer", sai, (InetSocketAddress)initialIsa, (Configuration)conf, (RpcScheduler)new FifoRpcScheduler(conf, 1));
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            if (address == null) {
                throw new IOException("Listener channel is closed");
            }
            this.isa = address;
            this.sleeper = new Sleeper(1000, (Stoppable)this);
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ZKWatcher getZooKeeper() {
            return this.zookeeper;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.isa.getHostName(), (int)this.isa.getPort(), (long)this.startcode);
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return this.stopped;
        }

        public void abort(String reason, Throwable error) {
            LOG.error(HBaseMarkers.FATAL, "Aborting on: " + reason, error);
            this.aborted = true;
            this.stopped = true;
            this.sleeper.skipSleepCycle();
        }

        private void initialize() throws IOException {
            Configuration zkConf = new Configuration(this.conf);
            zkConf.set("hbase.security.authentication", "simple");
            this.zookeeper = new ZKWatcher(zkConf, TokenServer.class.getSimpleName(), (Abortable)this, true);
            this.rpcServer.start();
            RegionCoprocessorEnvironment mockRegionCpEnv = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{HasRegionServerServices.class}));
            Mockito.when((Object)mockRegionCpEnv.getConfiguration()).thenReturn((Object)this.conf);
            Mockito.when((Object)mockRegionCpEnv.getClassLoader()).then(var1 -> Thread.currentThread().getContextClassLoader());
            RegionServerServices mockRss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
            Mockito.when((Object)mockRss.getRpcServer()).thenReturn((Object)this.rpcServer);
            Mockito.when((Object)((HasRegionServerServices)mockRegionCpEnv).getRegionServerServices()).thenReturn((Object)mockRss);
            super.start((CoprocessorEnvironment)mockRegionCpEnv);
            this.started = true;
        }

        @Override
        public void run() {
            try {
                this.initialize();
                while (!this.stopped) {
                    this.sleeper.sleep();
                }
            }
            catch (Exception e) {
                this.abort(e.getMessage(), e);
            }
            this.rpcServer.stop();
        }

        public boolean isStarted() {
            return this.started;
        }

        public void stop(String reason) {
            LOG.info("Stopping due to: " + reason);
            this.stopped = true;
            this.sleeper.skipSleepCycle();
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public InetSocketAddress getAddress() {
            return this.isa;
        }

        public SecretManager<? extends TokenIdentifier> getSecretManager() {
            return ((RpcServer)this.rpcServer).getSecretManager();
        }

        public AuthenticationProtos.GetAuthenticationTokenResponse getAuthenticationToken(RpcController controller, AuthenticationProtos.GetAuthenticationTokenRequest request) throws com.google.protobuf.ServiceException {
            LOG.debug("Authentication token request from " + (String)RpcServer.getRequestUserName().orElse(null));
            ServerRpcController serverController = new ServerRpcController();
            NonShadedBlockingRpcCallback callback = new NonShadedBlockingRpcCallback();
            this.getAuthenticationToken(null, request, callback);
            try {
                serverController.checkFailed();
                return (AuthenticationProtos.GetAuthenticationTokenResponse)callback.get();
            }
            catch (IOException ioe) {
                throw new com.google.protobuf.ServiceException((Throwable)ioe);
            }
        }

        public AuthenticationProtos.WhoAmIResponse whoAmI(RpcController controller, AuthenticationProtos.WhoAmIRequest request) throws com.google.protobuf.ServiceException {
            LOG.debug("whoAmI() request from " + (String)RpcServer.getRequestUserName().orElse(null));
            ServerRpcController serverController = new ServerRpcController();
            NonShadedBlockingRpcCallback callback = new NonShadedBlockingRpcCallback();
            this.whoAmI(null, request, callback);
            try {
                serverController.checkFailed();
                return (AuthenticationProtos.WhoAmIResponse)callback.get();
            }
            catch (IOException ioe) {
                throw new com.google.protobuf.ServiceException((Throwable)ioe);
            }
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

