/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestReadWriteSeqIdFiles {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReadWriteSeqIdFiles.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReadWriteSeqIdFiles.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private static FileSystem FS;
    private static Path REGION_DIR;

    @BeforeClass
    public static void setUp() throws IOException {
        FS = FileSystem.getLocal((Configuration)UTIL.getConfiguration());
        REGION_DIR = UTIL.getDataTestDir();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Test
    public void test() throws IOException {
        WALSplitter.writeRegionSequenceIdFile((FileSystem)FS, (Path)REGION_DIR, (long)1000L);
        Assert.assertEquals((long)1000L, (long)WALSplitter.getMaxRegionSequenceId((FileSystem)FS, (Path)REGION_DIR));
        WALSplitter.writeRegionSequenceIdFile((FileSystem)FS, (Path)REGION_DIR, (long)2000L);
        Assert.assertEquals((long)2000L, (long)WALSplitter.getMaxRegionSequenceId((FileSystem)FS, (Path)REGION_DIR));
        try {
            WALSplitter.writeRegionSequenceIdFile((FileSystem)FS, (Path)REGION_DIR, (long)1500L);
        }
        catch (IOException e) {
            LOG.info("Expected error", (Throwable)e);
        }
        Path editsdir = WALSplitter.getRegionDirRecoveredEditsDir((Path)REGION_DIR);
        FileStatus[] files = FSUtils.listStatus((FileSystem)FS, (Path)editsdir, (PathFilter)new PathFilter(){

            public boolean accept(Path p) {
                return WALSplitter.isSequenceIdFile((Path)p);
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        NavigableSet recoveredEdits = WALSplitter.getSplitEditFilesSorted((FileSystem)FS, (Path)REGION_DIR);
        Assert.assertEquals((long)0L, (long)recoveredEdits.size());
    }
}

