/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.util.LossyCounting;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetaTableMetrics
implements RegionCoprocessor {
    private ExampleRegionObserverMeta observer;
    private Map<String, Optional<Metric>> requestsMap;
    private RegionCoprocessorEnvironment regionCoprocessorEnv;
    private LossyCounting clientMetricsLossyCounting;
    private boolean active = false;
    private ImmutableMap<Class, MetaTableOps> opsNameMap = ImmutableMap.builder().put(Put.class, (Object)MetaTableOps.PUT).put(Get.class, (Object)MetaTableOps.GET).put(Delete.class, (Object)MetaTableOps.DELETE).build();

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this.observer);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof RegionCoprocessorEnvironment && ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable() != null && ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable().getName() != null && new String(((RegionCoprocessorEnvironment)env).getRegionInfo().getTable().getName(), StandardCharsets.UTF_8).equals(TableName.META_TABLE_NAME.toString())) {
            this.regionCoprocessorEnv = (RegionCoprocessorEnvironment)env;
            this.observer = new ExampleRegionObserverMeta();
            this.requestsMap = new ConcurrentHashMap<String, Optional<Metric>>();
            this.clientMetricsLossyCounting = new LossyCounting();
            this.active = true;
        } else {
            this.observer = new ExampleRegionObserverMeta();
        }
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        for (String meterName : this.requestsMap.keySet()) {
            MetricRegistry registry = this.regionCoprocessorEnv.getMetricRegistryForRegionServer();
            registry.remove(meterName);
        }
    }

    class ExampleRegionObserverMeta
    implements RegionCoprocessor,
    RegionObserver {
        ExampleRegionObserverMeta() {
        }

        @Override
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        @Override
        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (!MetaTableMetrics.this.active || !this.isMetaTableOp(e)) {
                return;
            }
            this.tableMetricRegisterAndMark(e, (Row)get);
            this.clientMetricRegisterAndMark(e);
            this.regionMetricRegisterAndMark(e, (Row)get);
            this.opMetricRegisterAndMark(e, (Row)get);
            this.opWithClientMetricRegisterAndMark(e, get);
        }

        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            if (!MetaTableMetrics.this.active || !this.isMetaTableOp(e)) {
                return;
            }
            this.tableMetricRegisterAndMark(e, (Row)put);
            this.clientMetricRegisterAndMark(e);
            this.regionMetricRegisterAndMark(e, (Row)put);
            this.opMetricRegisterAndMark(e, (Row)put);
            this.opWithClientMetricRegisterAndMark(e, put);
        }

        @Override
        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            if (!MetaTableMetrics.this.active || !this.isMetaTableOp(e)) {
                return;
            }
            this.tableMetricRegisterAndMark(e, (Row)delete);
            this.clientMetricRegisterAndMark(e);
            this.regionMetricRegisterAndMark(e, (Row)delete);
            this.opMetricRegisterAndMark(e, (Row)delete);
            this.opWithClientMetricRegisterAndMark(e, delete);
        }

        private void markMeterIfPresent(String requestMeter) {
            Metric metric;
            if (requestMeter.isEmpty()) {
                return;
            }
            Metric metric2 = metric = ((Optional)MetaTableMetrics.this.requestsMap.get(requestMeter)).isPresent() ? (Metric)((Optional)MetaTableMetrics.this.requestsMap.get(requestMeter)).get() : null;
            if (metric != null) {
                ((Meter)metric).mark();
            }
        }

        private void registerMeterIfNotPresent(ObserverContext<RegionCoprocessorEnvironment> e, String requestMeter) {
            if (requestMeter.isEmpty()) {
                return;
            }
            if (!MetaTableMetrics.this.requestsMap.containsKey(requestMeter)) {
                MetricRegistry registry = MetaTableMetrics.this.regionCoprocessorEnv.getMetricRegistryForRegionServer();
                registry.meter(requestMeter);
                MetaTableMetrics.this.requestsMap.put(requestMeter, registry.get(requestMeter));
            }
        }

        private void registerLossyCountingMeterIfNotPresent(ObserverContext<RegionCoprocessorEnvironment> e, String requestMeter, LossyCounting lossyCounting) {
            if (requestMeter.isEmpty()) {
                return;
            }
            Set<String> metersToBeRemoved = lossyCounting.addByOne(requestMeter);
            if (!MetaTableMetrics.this.requestsMap.containsKey(requestMeter) && metersToBeRemoved.contains(requestMeter)) {
                for (String meter : metersToBeRemoved) {
                    MetaTableMetrics.this.requestsMap.remove(meter);
                    MetricRegistry registry = MetaTableMetrics.this.regionCoprocessorEnv.getMetricRegistryForRegionServer();
                    registry.remove(meter);
                }
                return;
            }
            if (!MetaTableMetrics.this.requestsMap.containsKey(requestMeter)) {
                MetricRegistry registry = MetaTableMetrics.this.regionCoprocessorEnv.getMetricRegistryForRegionServer();
                registry.meter(requestMeter);
                MetaTableMetrics.this.requestsMap.put(requestMeter, registry.get(requestMeter));
            }
        }

        private String getTableNameFromOp(Row op) {
            String tableName = null;
            String tableRowKey = new String(op.getRow(), StandardCharsets.UTF_8);
            if (tableRowKey.isEmpty()) {
                return null;
            }
            tableName = tableRowKey.split(",").length > 0 ? tableRowKey.split(",")[0] : null;
            return tableName;
        }

        private String getRegionIdFromOp(Row op) {
            String regionId = null;
            String tableRowKey = new String(op.getRow(), StandardCharsets.UTF_8);
            if (tableRowKey.isEmpty()) {
                return null;
            }
            regionId = tableRowKey.split(",").length > 2 ? tableRowKey.split(",")[2] : null;
            return regionId;
        }

        private boolean isMetaTableOp(ObserverContext<RegionCoprocessorEnvironment> e) {
            return TableName.META_TABLE_NAME.toString().equals(new String(e.getEnvironment().getRegionInfo().getTable().getName(), StandardCharsets.UTF_8));
        }

        private void clientMetricRegisterAndMark(ObserverContext<RegionCoprocessorEnvironment> e) {
            String clientIP = RpcServer.getRemoteIp() != null ? RpcServer.getRemoteIp().toString() : "";
            String clientRequestMeter = this.clientRequestMeterName(clientIP);
            this.registerLossyCountingMeterIfNotPresent(e, clientRequestMeter, MetaTableMetrics.this.clientMetricsLossyCounting);
            this.markMeterIfPresent(clientRequestMeter);
        }

        private void tableMetricRegisterAndMark(ObserverContext<RegionCoprocessorEnvironment> e, Row op) {
            String tableName = this.getTableNameFromOp(op);
            String tableRequestMeter = this.tableMeterName(tableName);
            this.registerMeterIfNotPresent(e, tableRequestMeter);
            this.markMeterIfPresent(tableRequestMeter);
        }

        private void regionMetricRegisterAndMark(ObserverContext<RegionCoprocessorEnvironment> e, Row op) {
            String regionId = this.getRegionIdFromOp(op);
            String regionRequestMeter = this.regionMeterName(regionId);
            this.registerMeterIfNotPresent(e, regionRequestMeter);
            this.markMeterIfPresent(regionRequestMeter);
        }

        private void opMetricRegisterAndMark(ObserverContext<RegionCoprocessorEnvironment> e, Row op) {
            String opMeterName = this.opMeterName(op);
            this.registerMeterIfNotPresent(e, opMeterName);
            this.markMeterIfPresent(opMeterName);
        }

        private void opWithClientMetricRegisterAndMark(ObserverContext<RegionCoprocessorEnvironment> e, Object op) {
            String opWithClientMeterName = this.opWithClientMeterName(op);
            this.registerMeterIfNotPresent(e, opWithClientMeterName);
            this.markMeterIfPresent(opWithClientMeterName);
        }

        private String opWithClientMeterName(Object op) {
            String clientIP;
            String string = clientIP = RpcServer.getRemoteIp() != null ? RpcServer.getRemoteIp().toString() : "";
            if (clientIP.isEmpty()) {
                return "";
            }
            MetaTableOps ops = (MetaTableOps)((Object)MetaTableMetrics.this.opsNameMap.get(op.getClass()));
            String opWithClientMeterName = "";
            switch (ops) {
                case GET: {
                    opWithClientMeterName = String.format("MetaTable_client_%s_get_request", clientIP);
                    break;
                }
                case PUT: {
                    opWithClientMeterName = String.format("MetaTable_client_%s_put_request", clientIP);
                    break;
                }
                case DELETE: {
                    opWithClientMeterName = String.format("MetaTable_client_%s_delete_request", clientIP);
                    break;
                }
            }
            return opWithClientMeterName;
        }

        private String opMeterName(Object op) {
            MetaTableOps ops = (MetaTableOps)((Object)MetaTableMetrics.this.opsNameMap.get(op.getClass()));
            String opMeterName = "";
            switch (ops) {
                case GET: {
                    opMeterName = "MetaTable_get_request";
                    break;
                }
                case PUT: {
                    opMeterName = "MetaTable_put_request";
                    break;
                }
                case DELETE: {
                    opMeterName = "MetaTable_delete_request";
                    break;
                }
            }
            return opMeterName;
        }

        private String tableMeterName(String tableName) {
            return String.format("MetaTable_table_%s_request", tableName);
        }

        private String clientRequestMeterName(String clientIP) {
            if (clientIP.isEmpty()) {
                return "";
            }
            return String.format("MetaTable_client_%s_request", clientIP);
        }

        private String regionMeterName(String regionId) {
            return String.format("MetaTable_region_%s_request", regionId);
        }
    }

    static enum MetaTableOps {
        GET,
        PUT,
        DELETE;

    }
}

