/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.aes.AES;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class DefaultCipherProvider
implements CipherProvider {
    private static DefaultCipherProvider instance;
    private Configuration conf = HBaseConfiguration.create();

    public static DefaultCipherProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new DefaultCipherProvider();
        return instance;
    }

    private DefaultCipherProvider() {
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public Cipher getCipher(String name) {
        if (name.equalsIgnoreCase("AES")) {
            return new AES(this);
        }
        throw new RuntimeException("Cipher '" + name + "' is not supported by provider '" + this.getName() + "'");
    }

    @Override
    public String[] getSupportedCiphers() {
        return new String[]{"AES"};
    }
}

