/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;

public class OverwriteNonDefaultsWithLatestAvroPayload
extends OverwriteWithLatestAvroPayload {
    public OverwriteNonDefaultsWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteNonDefaultsWithLatestAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option<IndexedRecord> recordOption = this.getInsertValue(schema);
        if (!recordOption.isPresent()) {
            return Option.empty();
        }
        GenericRecord insertRecord = (GenericRecord)recordOption.get();
        GenericRecord currentRecord = (GenericRecord)currentValue;
        if (this.isDeleteRecord(insertRecord)) {
            return Option.empty();
        }
        List fields = schema.getFields();
        fields.forEach(field -> {
            Object defaultValue;
            Object value = insertRecord.get(field.name());
            if (!this.overwriteField(value, defaultValue = field.defaultVal()).booleanValue()) {
                currentRecord.put(field.name(), value);
            }
        });
        return Option.of(currentRecord);
    }
}

