/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieHFileDataBlock
extends HoodieDataBlock {
    private static final Logger LOG = LogManager.getLogger(HoodieHFileDataBlock.class);
    private static Compression.Algorithm compressionAlgorithm = Compression.Algorithm.GZ;
    private static int blockSize = 0x100000;

    public HoodieHFileDataBlock(@Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> logBlockHeader, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> logBlockFooter, @Nonnull Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, @Nonnull Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily) {
        super(logBlockHeader, logBlockFooter, blockContentLocation, content, inputStream, readBlockLazily);
    }

    public HoodieHFileDataBlock(HoodieLogFile logFile, FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, long position, long blockSize, long blockEndpos, Schema readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(content, inputStream, readBlockLazily, Option.of(new HoodieLogBlock.HoodieLogBlockContentLocation(logFile, position, blockSize, blockEndpos)), readerSchema, header, footer);
    }

    public HoodieHFileDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>());
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords() throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(blockSize).withCompression(compressionAlgorithm).build();
        Configuration conf = new Configuration();
        CacheConfig cacheConfig = new CacheConfig(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FSDataOutputStream ostream = new FSDataOutputStream((OutputStream)baos, null);
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConfig).withOutputStream(ostream).withFileContext(context).create();
        TreeMap<String, byte[]> sortedRecordsMap = new TreeMap<String, byte[]>();
        Iterator itr = this.records.iterator();
        boolean useIntegerKey = false;
        int key = 0;
        int keySize = 0;
        Schema.Field keyField = ((IndexedRecord)this.records.get(0)).getSchema().getField("_hoodie_record_key");
        if (keyField == null) {
            useIntegerKey = true;
            keySize = (int)Math.ceil(Math.log(this.records.size())) + 1;
        }
        while (itr.hasNext()) {
            IndexedRecord record = (IndexedRecord)itr.next();
            String recordKey2 = useIntegerKey ? String.format("%" + keySize + "s", key++) : record.get(keyField.pos()).toString();
            byte[] recordBytes2 = HoodieAvroUtils.indexedRecordToBytes(record);
            ValidationUtils.checkState(!sortedRecordsMap.containsKey(recordKey2), "Writing multiple records with same key not supported for " + this.getClass().getName());
            sortedRecordsMap.put(recordKey2, recordBytes2);
        }
        sortedRecordsMap.forEach((recordKey, recordBytes) -> {
            try {
                KeyValue kv = new KeyValue(recordKey.getBytes(), null, null, recordBytes);
                writer.append((Cell)kv);
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException serializing records", e);
            }
        });
        writer.close();
        ostream.flush();
        ostream.close();
        return baos.toByteArray();
    }

    @Override
    protected void deserializeRecords() throws IOException {
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        if (this.schema == null) {
            this.schema = writerSchema;
        }
        HoodieHFileReader reader = new HoodieHFileReader(this.getContent().get());
        List records = reader.readAllRecords(writerSchema, this.schema);
        this.records = records.stream().map(t -> (IndexedRecord)t.getSecond()).collect(Collectors.toList());
        this.deflate();
    }
}

