/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.model.BootstrapBaseFileMapping;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SpillableMapBasedFileSystemView
extends HoodieTableFileSystemView {
    private static final Logger LOG = LogManager.getLogger(SpillableMapBasedFileSystemView.class);
    private final long maxMemoryForFileGroupMap;
    private final long maxMemoryForPendingCompaction;
    private final long maxMemoryForBootstrapBaseFile;
    private final long maxMemoryForReplaceFileGroups;
    private final long maxMemoryForClusteringFileGroups;
    private final String baseStoreDir;

    public SpillableMapBasedFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileSystemViewStorageConfig config) {
        super(config.isIncrementalTimelineSyncEnabled());
        this.maxMemoryForFileGroupMap = config.getMaxMemoryForFileGroupMap();
        this.maxMemoryForPendingCompaction = config.getMaxMemoryForPendingCompaction();
        this.maxMemoryForBootstrapBaseFile = config.getMaxMemoryForBootstrapBaseFile();
        this.maxMemoryForReplaceFileGroups = config.getMaxMemoryForReplacedFileGroups();
        this.maxMemoryForClusteringFileGroups = config.getMaxMemoryForPendingClusteringFileGroups();
        this.baseStoreDir = config.getSpillableDir();
        this.init(metaClient, visibleActiveTimeline);
    }

    public SpillableMapBasedFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileStatus[] fileStatuses, FileSystemViewStorageConfig config) {
        this(metaClient, visibleActiveTimeline, config);
        this.addFilesToView(fileStatuses);
    }

    @Override
    protected Map<String, List<HoodieFileGroup>> createPartitionToFileGroups() {
        try {
            LOG.info((Object)("Creating Partition To File groups map using external spillable Map. Max Mem=" + this.maxMemoryForFileGroupMap + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            return new ExternalSpillableMap<String, List<HoodieFileGroup>>(this.maxMemoryForFileGroupMap, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> createFileIdToPendingCompactionMap(Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fgIdToPendingCompaction) {
        try {
            LOG.info((Object)("Creating Pending Compaction map using external spillable Map. Max Mem=" + this.maxMemoryForPendingCompaction + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            ExternalSpillableMap<HoodieFileGroupId, Pair<String, CompactionOperation>> pendingMap = new ExternalSpillableMap<HoodieFileGroupId, Pair<String, CompactionOperation>>(this.maxMemoryForPendingCompaction, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
            pendingMap.putAll(fgIdToPendingCompaction);
            return pendingMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<HoodieFileGroupId, BootstrapBaseFileMapping> createFileIdToBootstrapBaseFileMap(Map<HoodieFileGroupId, BootstrapBaseFileMapping> fileGroupIdBootstrapBaseFileMap) {
        try {
            LOG.info((Object)("Creating bootstrap base File Map using external spillable Map. Max Mem=" + this.maxMemoryForBootstrapBaseFile + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            ExternalSpillableMap<HoodieFileGroupId, BootstrapBaseFileMapping> pendingMap = new ExternalSpillableMap<HoodieFileGroupId, BootstrapBaseFileMapping>(this.maxMemoryForBootstrapBaseFile, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
            pendingMap.putAll(fileGroupIdBootstrapBaseFileMap);
            return pendingMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<HoodieFileGroupId, HoodieInstant> createFileIdToReplaceInstantMap(Map<HoodieFileGroupId, HoodieInstant> replacedFileGroups) {
        try {
            LOG.info((Object)("Creating file group id to replace instant map using external spillable Map. Max Mem=" + this.maxMemoryForReplaceFileGroups + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            ExternalSpillableMap<HoodieFileGroupId, HoodieInstant> pendingMap = new ExternalSpillableMap<HoodieFileGroupId, HoodieInstant>(this.maxMemoryForReplaceFileGroups, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
            pendingMap.putAll(replacedFileGroups);
            return pendingMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<HoodieFileGroupId, HoodieInstant> createFileIdToPendingClusteringMap(Map<HoodieFileGroupId, HoodieInstant> fileGroupsInClustering) {
        try {
            LOG.info((Object)("Creating file group id to clustering instant map using external spillable Map. Max Mem=" + this.maxMemoryForClusteringFileGroups + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            ExternalSpillableMap<HoodieFileGroupId, HoodieInstant> pendingMap = new ExternalSpillableMap<HoodieFileGroupId, HoodieInstant>(this.maxMemoryForClusteringFileGroups, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
            pendingMap.putAll(fileGroupsInClustering);
            return pendingMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroups() {
        return ((ExternalSpillableMap)this.partitionToFileGroupsMap).valueStream().flatMap(fg -> ((List)fg).stream());
    }

    @Override
    Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations() {
        return ((ExternalSpillableMap)this.fgIdToPendingCompaction).valueStream();
    }

    @Override
    Stream<BootstrapBaseFileMapping> fetchBootstrapBaseFiles() {
        return ((ExternalSpillableMap)this.fgIdToBootstrapBaseFile).valueStream();
    }

    @Override
    public Stream<HoodieFileGroup> fetchAllStoredFileGroups() {
        return ((ExternalSpillableMap)this.partitionToFileGroupsMap).valueStream().flatMap(fg -> ((List)fg).stream());
    }

    @Override
    protected void removeReplacedFileIdsAtInstants(Set<String> instants) {
        Stream<HoodieFileGroupId> fileIdsToRemove = this.fgIdToReplaceInstants.entrySet().stream().map(entry -> {
            if (instants.contains(((HoodieInstant)entry.getValue()).getTimestamp())) {
                return Option.of(entry.getKey());
            }
            return Option.ofNullable(null);
        }).filter(Option::isPresent).map(Option::get);
        fileIdsToRemove.forEach(fileGroupId -> {
            HoodieInstant cfr_ignored_0 = (HoodieInstant)this.fgIdToReplaceInstants.remove(fileGroupId);
        });
    }
}

