/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMetadataMetrics
implements Serializable {
    public static final String LOOKUP_PARTITIONS_STR = "lookup_partitions";
    public static final String LOOKUP_FILES_STR = "lookup_files";
    public static final String VALIDATE_PARTITIONS_STR = "validate_partitions";
    public static final String VALIDATE_FILES_STR = "validate_files";
    public static final String VALIDATE_ERRORS_STR = "validate_errors";
    public static final String SCAN_STR = "scan";
    public static final String BASEFILE_READ_STR = "basefile_read";
    public static final String INITIALIZE_STR = "initialize";
    public static final String SYNC_STR = "sync";
    public static final String STAT_TOTAL_BASE_FILE_SIZE = "totalBaseFileSizeInBytes";
    public static final String STAT_TOTAL_LOG_FILE_SIZE = "totalLogFileSizeInBytes";
    public static final String STAT_COUNT_BASE_FILES = "baseFileCount";
    public static final String STAT_COUNT_LOG_FILES = "logFileCount";
    public static final String STAT_COUNT_PARTITION = "partitionCount";
    public static final String STAT_IN_SYNC = "isInSync";
    public static final String STAT_LAST_COMPACTION_TIMESTAMP = "lastCompactionTimestamp";
    private static final Logger LOG = LogManager.getLogger(HoodieMetadataMetrics.class);
    private final Registry metricsRegistry;

    public HoodieMetadataMetrics(Registry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public Map<String, String> getStats(boolean detailed, HoodieTableMetaClient metaClient, HoodieTableMetadata metadata) {
        try {
            metaClient.reloadActiveTimeline();
            HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline());
            return this.getStats(fsView, detailed, metadata);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unable to get metadata stats.", ioe);
        }
    }

    private Map<String, String> getStats(HoodieTableFileSystemView fsView, boolean detailed, HoodieTableMetadata tableMetadata) throws IOException {
        HashMap<String, String> stats = new HashMap<String, String>();
        long totalBaseFileSizeInBytes = 0L;
        long totalLogFileSizeInBytes = 0L;
        int baseFileCount = 0;
        int logFileCount = 0;
        List latestSlices = fsView.getLatestFileSlices(MetadataPartitionType.FILES.partitionPath()).collect(Collectors.toList());
        for (FileSlice slice : latestSlices) {
            if (slice.getBaseFile().isPresent()) {
                totalBaseFileSizeInBytes += slice.getBaseFile().get().getFileStatus().getLen();
                ++baseFileCount;
            }
            Iterator it = slice.getLogFiles().iterator();
            while (it.hasNext()) {
                totalLogFileSizeInBytes += ((HoodieLogFile)it.next()).getFileStatus().getLen();
                ++logFileCount;
            }
        }
        stats.put(STAT_TOTAL_BASE_FILE_SIZE, String.valueOf(totalBaseFileSizeInBytes));
        stats.put(STAT_TOTAL_LOG_FILE_SIZE, String.valueOf(totalLogFileSizeInBytes));
        stats.put(STAT_COUNT_BASE_FILES, String.valueOf(baseFileCount));
        stats.put(STAT_COUNT_LOG_FILES, String.valueOf(logFileCount));
        if (detailed) {
            stats.put(STAT_COUNT_PARTITION, String.valueOf(tableMetadata.getAllPartitionPaths().size()));
            stats.put(STAT_IN_SYNC, String.valueOf(tableMetadata.isInSync()));
        }
        return stats;
    }

    protected void updateMetrics(String action, long durationInMs) {
        if (this.metricsRegistry == null) {
            return;
        }
        String countKey = action + ".count";
        String durationKey = action + ".totalDuration";
        this.metricsRegistry.add(countKey, 1L);
        this.metricsRegistry.add(durationKey, durationInMs);
        LOG.info((Object)String.format("Updating metadata metrics (%s=%dms, %s=1)", durationKey, durationInMs, countKey));
    }

    public void updateMetrics(long totalBaseFileSizeInBytes, long totalLogFileSizeInBytes, int baseFileCount, int logFileCount) {
        if (this.metricsRegistry == null) {
            return;
        }
        this.metricsRegistry.add("basefile.size", totalBaseFileSizeInBytes);
        this.metricsRegistry.add("logfile.size", totalLogFileSizeInBytes);
        this.metricsRegistry.add("basefile.count", baseFileCount);
        this.metricsRegistry.add("logfile.count", logFileCount);
        LOG.info((Object)String.format("Updating metadata size metrics (basefile.size=%d, logfile.size=%d, basefile.count=%d, logfile.count=%d)", totalBaseFileSizeInBytes, totalLogFileSizeInBytes, baseFileCount, logFileCount));
    }

    public Registry registry() {
        return this.metricsRegistry;
    }
}

