/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieRowCreateHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class BulkInsertDataInternalWriterHelper {
    private static final Logger LOG = LogManager.getLogger(BulkInsertDataInternalWriterHelper.class);
    private final String instantTime;
    private final int taskPartitionId;
    private final long taskId;
    private final long taskEpochId;
    private final HoodieTable hoodieTable;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final List<HoodieInternalWriteStatus> writeStatusList = new ArrayList<HoodieInternalWriteStatus>();
    private HoodieRowCreateHandle handle;
    private String lastKnownPartitionPath = null;
    private String fileIdPrefix;
    private int numFilesWritten = 0;

    public BulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType) {
        this.hoodieTable = hoodieTable;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.structType = structType;
        this.fileIdPrefix = UUID.randomUUID().toString();
    }

    public void write(InternalRow record) throws IOException {
        try {
            String partitionPath = record.getUTF8String(((Integer)HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_partition_path")).intValue()).toString();
            if (this.lastKnownPartitionPath == null || !this.lastKnownPartitionPath.equals(partitionPath) || !this.handle.canWrite()) {
                LOG.info((Object)("Creating new file for partition path " + partitionPath));
                this.createNewHandle(partitionPath);
                this.lastKnownPartitionPath = partitionPath;
            }
            this.handle.write(record);
        }
        catch (Throwable t) {
            LOG.error((Object)"Global error thrown while trying to write records in HoodieRowCreateHandle ", t);
            throw t;
        }
    }

    public List<HoodieInternalWriteStatus> getWriteStatuses() throws IOException {
        this.close();
        return this.writeStatusList;
    }

    public void abort() {
    }

    private void createNewHandle(String partitionPath) throws IOException {
        if (null != this.handle) {
            this.close();
        }
        this.handle = new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType);
    }

    public void close() throws IOException {
        if (null != this.handle) {
            this.writeStatusList.add(this.handle.close());
            this.handle = null;
        }
    }

    private String getNextFileId() {
        return String.format("%s-%d", this.fileIdPrefix, this.numFilesWritten++);
    }
}

