/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.Serializable;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class TimeValuePair
implements Serializable,
Comparable<TimeValuePair> {
    private long timestamp;
    private TsPrimitiveType value;

    public TimeValuePair(long timestamp, TsPrimitiveType value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public TsPrimitiveType getValue() {
        return this.value;
    }

    public void setValue(TsPrimitiveType value) {
        this.value = value;
    }

    public Object[] getValues() {
        if (this.value.getDataType() == TSDataType.VECTOR) {
            TsPrimitiveType[] vector = this.value.getVector();
            Object[] values = new Object[vector.length];
            for (int i = 0; i < vector.length; ++i) {
                values[i] = vector[i] == null ? null : vector[i].getValue();
            }
            return values;
        }
        Object[] values = new Object[]{this.value.getValue()};
        return values;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.timestamp).append(" : ").append(this.getValue());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof TimeValuePair) {
            return ((TimeValuePair)object).getTimestamp() == this.timestamp && ((TimeValuePair)object).getValue() != null && ((TimeValuePair)object).getValue().equals((Object)this.value);
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.timestamp).hashCode() + this.value.hashCode();
    }

    public int getSize() {
        return 16 + this.value.getSize();
    }

    @Override
    public int compareTo(TimeValuePair o) {
        return Long.compare(this.getTimestamp(), o.getTimestamp());
    }
}

