/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block;

import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class TsBlockUtil {
    private TsBlockUtil() {
    }

    public static TsBlock skipPointsOutOfTimeRange(TsBlock tsBlock, TimeRange targetTimeRange, boolean ascending) {
        int firstIndex = TsBlockUtil.getFirstConditionIndex(tsBlock, targetTimeRange, ascending);
        return tsBlock.subTsBlock(firstIndex);
    }

    public static int getFirstConditionIndex(TsBlock tsBlock, TimeRange targetTimeRange, boolean ascending) {
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        long targetTime = ascending ? targetTimeRange.getMin() : targetTimeRange.getMax();
        int left = 0;
        int right = timeColumn.getPositionCount() - 1;
        while (left < right) {
            int mid = left + right >> 1;
            if (timeColumn.getLongWithoutCheck(mid) < targetTime) {
                if (ascending) {
                    left = mid + 1;
                    continue;
                }
                right = mid;
                continue;
            }
            if (timeColumn.getLongWithoutCheck(mid) > targetTime) {
                if (ascending) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (timeColumn.getLongWithoutCheck(mid) != targetTime) continue;
            return mid;
        }
        return left;
    }
}

