/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.file.FileStreamSinkTask;
import org.apache.kafka.connect.sink.SinkConnector;

public class FileStreamSinkConnector
extends SinkConnector {
    public static final String FILE_CONFIG = "file";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("file", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Destination filename. If not specified, the standard output will be used");
    private String filename;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> props) {
        this.filename = props.get(FILE_CONFIG);
    }

    public Class<? extends Task> taskClass() {
        return FileStreamSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < maxTasks; ++i) {
            HashMap<String, String> config = new HashMap<String, String>();
            if (this.filename != null) {
                config.put(FILE_CONFIG, this.filename);
            }
            configs.add(config);
        }
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }
}

