/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.ConsoleProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        OptionSpecBuilder syncOpt = parser.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        OptionSpecBuilder compressOpt = parser.accepts("compress", "If set, messages batches are sent compressed");
        ArgumentAcceptingOptionSpec batchSizeOpt = parser.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec messageSendMaxRetriesOpt = parser.accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec retryBackoffMsOpt = parser.accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(100L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec sendTimeoutOpt = parser.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting suffient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(1000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec queueSizeOpt = parser.accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting suffient batch size.").withRequiredArg().describedAs("queue_size").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(10000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec queueEnqueueTimeoutMsOpt = parser.accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(Integer.MAX_VALUE), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec requestRequiredAcksOpt = parser.accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec requestTimeoutMsOpt = parser.accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec valueEncoderOpt = parser.accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec keyEncoderOpt = parser.accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec messageReaderOpt = parser.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)ConsoleProducer.LineMessageReader.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec socketBufferSizeOpt = parser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec propertyOpt = parser.accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSet options = parser.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, brokerListOpt})).foreach((Function1)new Serializable(parser, options){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = parser$1;
                this.options$1 = options$1;
            }
        });
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        boolean sync = options.has((OptionSpec)syncOpt);
        boolean compress = options.has((OptionSpec)compressOpt);
        Integer batchSize = (Integer)options.valueOf((OptionSpec)batchSizeOpt);
        Long sendTimeout = (Long)options.valueOf((OptionSpec)sendTimeoutOpt);
        Long queueSize = (Long)options.valueOf((OptionSpec)queueSizeOpt);
        Long queueEnqueueTimeoutMs = (Long)options.valueOf((OptionSpec)queueEnqueueTimeoutMsOpt);
        Integer requestRequiredAcks = (Integer)options.valueOf((OptionSpec)requestRequiredAcksOpt);
        Integer requestTimeoutMs = (Integer)options.valueOf((OptionSpec)requestTimeoutMsOpt);
        String keyEncoderClass = (String)options.valueOf((OptionSpec)keyEncoderOpt);
        String valueEncoderClass = (String)options.valueOf((OptionSpec)valueEncoderOpt);
        String readerClass = (String)options.valueOf((OptionSpec)messageReaderOpt);
        Integer socketBuffer = (Integer)options.valueOf((OptionSpec)socketBufferSizeOpt);
        Properties cmdLineProps = this.parseLineReaderArgs((Iterable<String>)JavaConversions$.MODULE$.asScalaBuffer(options.valuesOf((OptionSpec)propertyOpt)));
        ((Hashtable)cmdLineProps).put("topic", topic);
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", brokerList);
        int codec = compress ? DefaultCompressionCodec$.MODULE$.codec() : NoCompressionCodec$.MODULE$.codec();
        ((Hashtable)props).put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)codec)).toString());
        ((Hashtable)props).put("producer.type", sync ? "sync" : "async");
        Object object = options.has((OptionSpec)batchSizeOpt) ? ((Hashtable)props).put("batch.num.messages", batchSize.toString()) : BoxedUnit.UNIT;
        ((Hashtable)props).put("message.send.max.retries", ((Integer)options.valueOf((OptionSpec)messageSendMaxRetriesOpt)).toString());
        ((Hashtable)props).put("retry.backoff.ms", ((Long)options.valueOf((OptionSpec)retryBackoffMsOpt)).toString());
        ((Hashtable)props).put("queue.buffering.max.ms", sendTimeout.toString());
        ((Hashtable)props).put("queue.buffering.max.messages", queueSize.toString());
        ((Hashtable)props).put("queue.enqueue.timeout.ms", queueEnqueueTimeoutMs.toString());
        ((Hashtable)props).put("request.required.acks", requestRequiredAcks.toString());
        ((Hashtable)props).put("request.timeout.ms", requestTimeoutMs.toString());
        ((Hashtable)props).put("key.serializer.class", keyEncoderClass);
        ((Hashtable)props).put("serializer.class", valueEncoderClass);
        ((Hashtable)props).put("send.buffer.bytes", socketBuffer.toString());
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(readerClass).newInstance();
        reader.init(System.in, cmdLineProps);
        try {
            Producer producer = new Producer(new ProducerConfig(props));
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final Producer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            KeyedMessage message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer.send(Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseLineReaderArgs(Iterable<String> args) {
        void var3_3;
        Iterable splits = (Iterable)((TraversableLike)((TraversableLike)args.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split("=");
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$2) {
                return x$2 == null;
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$3) {
                return x$3.length == 0;
            }
        });
        if (!splits.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$4) {
                return x$4.length == 2;
            }
        })) {
            System.err.println(new StringBuilder().append((Object)"Invalid line reader properties: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props = new Properties();
        splits.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] a) {
                return ((Hashtable)this.props$1).put(a[0], a[1]);
            }
            {
                this.props$1 = props$1;
            }
        });
        return var3_3;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

