/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.AwaitingSync$;
import kafka.coordinator.Dead$;
import kafka.coordinator.DelayedHeartbeat;
import kafka.coordinator.DelayedJoin;
import kafka.coordinator.DelayedStore;
import kafka.coordinator.GroupConfig;
import kafka.coordinator.GroupCoordinator$;
import kafka.coordinator.GroupMetadata;
import kafka.coordinator.GroupMetadataManager;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupState;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberMetadata;
import kafka.coordinator.MemberSummary;
import kafka.coordinator.OffsetConfig;
import kafka.coordinator.PreparingRebalance$;
import kafka.coordinator.Stable$;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.GroupKey;
import kafka.server.KafkaConfig;
import kafka.server.MemberKey;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0011Mb\u0001B\u0001\u0003\u0001\u001d\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005\r!\u0011aC2p_J$\u0017N\\1u_JT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\tEJ|7.\u001a:JIV\tq\u0003\u0005\u0002\n1%\u0011\u0011D\u0003\u0002\u0004\u0013:$\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0017\u001d\u0014x.\u001e9D_:4\u0017nZ\u000b\u0002?A\u0011\u0001%I\u0007\u0002\u0005%\u0011!E\u0001\u0002\f\u000fJ|W\u000f]\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003 \u000319'o\\;q\u0007>tg-[4!\u0011!1\u0003A!b\u0001\n\u00039\u0013\u0001D8gMN,GoQ8oM&<W#\u0001\u0015\u0011\u0005\u0001J\u0013B\u0001\u0016\u0003\u00051yeMZ:fi\u000e{gNZ5h\u0011!a\u0003A!A!\u0002\u0013A\u0013!D8gMN,GoQ8oM&<\u0007\u0005\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u000319'o\\;q\u001b\u0006t\u0017mZ3s+\u0005\u0001\u0004C\u0001\u00112\u0013\t\u0011$A\u0001\u000bHe>,\b/T3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005a\u0005iqM]8va6\u000bg.Y4fe\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\u0013Q\u0016\f'\u000f\u001e2fCR\u0004VO]4bi>\u0014\u00180F\u00019!\rIDHP\u0007\u0002u)\u00111\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005uR$!\u0007#fY\u0006LX\rZ(qKJ\fG/[8o!V\u0014x-\u0019;pef\u0004\"\u0001I \n\u0005\u0001\u0013!\u0001\u0005#fY\u0006LX\r\u001a%fCJ$(-Z1u\u0011!\u0011\u0005A!A!\u0002\u0013A\u0014a\u00055fCJ$(-Z1u!V\u0014x-\u0019;pef\u0004\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\u0002\u001b)|\u0017N\u001c)ve\u001e\fGo\u001c:z+\u00051\u0005cA\u001d=\u000fB\u0011\u0001\u0005S\u0005\u0003\u0013\n\u00111\u0002R3mCf,GMS8j]\"A1\n\u0001B\u0001B\u0003%a)\u0001\bk_&t\u0007+\u001e:hCR|'/\u001f\u0011\t\u00115\u0003!\u0011!Q\u0001\n9\u000bA\u0001^5nKB\u0011q\nW\u0007\u0002!*\u0011\u0011#\u0015\u0006\u0003%N\u000baaY8n[>t'BA\u0003U\u0015\t)f+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0006\u0019qN]4\n\u0005e\u0003&\u0001\u0002+j[\u0016DQa\u0017\u0001\u0005\u0002q\u000ba\u0001P5oSRtD\u0003C/_?\u0002\f'm\u00193\u0011\u0005\u0001\u0002\u0001\"B\u000b[\u0001\u00049\u0002\"B\u000f[\u0001\u0004y\u0002\"\u0002\u0014[\u0001\u0004A\u0003\"\u0002\u0018[\u0001\u0004\u0001\u0004\"\u0002\u001c[\u0001\u0004A\u0004\"\u0002#[\u0001\u00041\u0005\"B'[\u0001\u0004qU\u0001\u00024\u0001\u0001\u001d\u0014ABS8j]\u000e\u000bG\u000e\u001c2bG.\u0004B!\u00035k[&\u0011\u0011N\u0003\u0002\n\rVt7\r^5p]F\u0002\"\u0001I6\n\u00051\u0014!a\u0004&pS:<%o\\;q%\u0016\u001cX\u000f\u001c;\u0011\u0005%q\u0017BA8\u000b\u0005\u0011)f.\u001b;\u0006\tE\u0004\u0001A\u001d\u0002\r'ft7mQ1mY\n\f7m\u001b\t\u0006\u0013M,80\\\u0005\u0003i*\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0007%1\b0\u0003\u0002x\u0015\t)\u0011I\u001d:bsB\u0011\u0011\"_\u0005\u0003u*\u0011AAQ=uKB\u0011\u0011\u0002`\u0005\u0003{*\u0011Qa\u00155peRD\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\tSN\f5\r^5wKV\u0011\u00111\u0001\t\u0005\u0003\u000b\t9\"\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0019\tGo\\7jG*!\u0011QBA\b\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003#\t\u0019\"\u0001\u0003vi&d'BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0001\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u0007\t\u0011\"[:BGRLg/\u001a\u0011\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005\u0019rN\u001a4tKR\u001cHk\u001c9jG\u000e{gNZ5hgV\u0011\u0011Q\u0005\t\u0005\u0003O\tI#\u0004\u0002\u0002\u0010%!\u00111FA\b\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003\u001d\u0019H/\u0019:ukB$\u0012!\u001c\u0005\b\u0003k\u0001A\u0011AA\u0019\u0003!\u0019\b.\u001e;e_^t\u0007bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0010Q\u0006tG\r\\3K_&twI]8vaR\tR.!\u0010\u0002P\u0005M\u0013qKA.\u0003?\n\u0019'!\"\t\u0011\u0005}\u0012q\u0007a\u0001\u0003\u0003\nqa\u001a:pkBLE\r\u0005\u0003\u0002D\u0005%cbA\u0005\u0002F%\u0019\u0011q\t\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9E\u0003\u0005\t\u0003#\n9\u00041\u0001\u0002B\u0005AQ.Z7cKJLE\r\u0003\u0005\u0002V\u0005]\u0002\u0019AA!\u0003!\u0019G.[3oi&#\u0007\u0002CA-\u0003o\u0001\r!!\u0011\u0002\u0015\rd\u0017.\u001a8u\u0011>\u001cH\u000fC\u0004\u0002^\u0005]\u0002\u0019A\f\u0002!M,7o]5p]RKW.Z8vi6\u001b\b\u0002CA1\u0003o\u0001\r!!\u0011\u0002\u0019A\u0014x\u000e^8d_2$\u0016\u0010]3\t\u0011\u0005\u0015\u0014q\u0007a\u0001\u0003O\n\u0011\u0002\u001d:pi>\u001cw\u000e\\:\u0011\r\u0005%\u0014\u0011PA@\u001d\u0011\tY'!\u001e\u000f\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u0002x)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002|\u0005u$\u0001\u0002'jgRT1!a\u001e\u000b!\u0019I\u0011\u0011QA!k&\u0019\u00111\u0011\u0006\u0003\rQ+\b\u000f\\33\u0011!\t9)a\u000eA\u0002\u0005%\u0015\u0001\u0005:fgB|gn]3DC2d'-Y2l!\r\tY)Z\u0007\u0002\u0001!9\u0011q\u0012\u0001\u0005\n\u0005E\u0015a\u00033p\u0015>Lgn\u0012:pkB$\u0012#\\AJ\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0011!\t)*!$A\u0002\u0005]\u0015!B4s_V\u0004\bc\u0001\u0011\u0002\u001a&\u0019\u00111\u0014\u0002\u0003\u001b\u001d\u0013x.\u001e9NKR\fG-\u0019;b\u0011!\t\t&!$A\u0002\u0005\u0005\u0003\u0002CA+\u0003\u001b\u0003\r!!\u0011\t\u0011\u0005e\u0013Q\u0012a\u0001\u0003\u0003Bq!!\u0018\u0002\u000e\u0002\u0007q\u0003\u0003\u0005\u0002b\u00055\u0005\u0019AA!\u0011!\t)'!$A\u0002\u0005\u001d\u0004\u0002CAD\u0003\u001b\u0003\r!!#\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006y\u0001.\u00198eY\u0016\u001c\u0016P\\2He>,\b\u000fF\u0006n\u0003c\u000b\u0019,a.\u0002:\u0006%\u0007\u0002CA \u0003W\u0003\r!!\u0011\t\u000f\u0005U\u00161\u0016a\u0001/\u0005Qq-\u001a8fe\u0006$\u0018n\u001c8\t\u0011\u0005E\u00131\u0016a\u0001\u0003\u0003B\u0001\"a/\u0002,\u0002\u0007\u0011QX\u0001\u0010OJ|W\u000f]!tg&<g.\\3oiB9\u0011qXAc\u0003\u0003*XBAAa\u0015\r\t\u0019MC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAd\u0003\u0003\u00141!T1q\u0011!\t9)a+A\u0002\u0005-\u0007cAAFa\"9\u0011q\u001a\u0001\u0005\n\u0005E\u0017a\u00033p'ft7m\u0012:pkB$2\"\\Aj\u0003+\fI.a7\u0002^\"A\u0011QSAg\u0001\u0004\t9\nC\u0004\u0002X\u00065\u0007\u0019A\f\u0002\u0019\u001d,g.\u001a:bi&|g.\u00133\t\u0011\u0005E\u0013Q\u001aa\u0001\u0003\u0003B\u0001\"a/\u0002N\u0002\u0007\u0011Q\u0018\u0005\t\u0003\u000f\u000bi\r1\u0001\u0002L\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018\u0001\u00055b]\u0012dW\rT3bm\u0016<%o\\;q)\u001di\u0017Q]At\u0003WD\u0001\"a\u0010\u0002`\u0002\u0007\u0011\u0011\t\u0005\t\u0003S\fy\u000e1\u0001\u0002B\u0005Q1m\u001c8tk6,'/\u00133\t\u0011\u0005\u001d\u0015q\u001ca\u0001\u0003[\u0004B!\u00035|[\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\u0018a\u00045b]\u0012dW\rS3beR\u0014W-\u0019;\u0015\u00135\f)0a>\u0002z\u0006m\b\u0002CA \u0003_\u0004\r!!\u0011\t\u0011\u0005E\u0013q\u001ea\u0001\u0003\u0003Bq!a6\u0002p\u0002\u0007q\u0003\u0003\u0005\u0002\b\u0006=\b\u0019AAw\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\t1\u0003[1oI2,7i\\7nSR|eMZ:fiN$2\"\u001cB\u0002\u0005\u000b\u00119A!\u0003\u0003*!A\u0011qHA\u007f\u0001\u0004\t\t\u0005\u0003\u0005\u0002R\u0005u\b\u0019AA!\u0011\u001d\t9.!@A\u0002]A\u0001Ba\u0003\u0002~\u0002\u0007!QB\u0001\u000f_\u001a47/\u001a;NKR\fG-\u0019;b!!\u0011yA!\u0006\u0003\u0018\t}QB\u0001B\t\u0015\u0011\u0011\u0019\"!1\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAd\u0005#\u0001BA!\u0007\u0003\u001c5\t\u0011+C\u0002\u0003\u001eE\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003\"\t\u0015RB\u0001B\u0012\u0015\t\u0011F!\u0003\u0003\u0003(\t\r\"!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"A\u0011qQA\u007f\u0001\u0004\u0011Y\u0003E\u0003\nQ\n5R\u000eE\u0004\u0003\u0010\tU!qC>\t\u000f\tE\u0002\u0001\"\u0001\u00034\u0005\u0011\u0002.\u00198eY\u00164U\r^2i\u001f\u001a47/\u001a;t)\u0019\u0011)Da\u0013\u0003NAA\u0011qXAc\u0005/\u00119\u0004\u0005\u0003\u0003:\t\u0015c\u0002\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}\u0012+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\u0019E!\u0010\u0002'=3gm]3u\r\u0016$8\r\u001b*fgB|gn]3\n\t\t\u001d#\u0011\n\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\t\r#Q\b\u0005\t\u0003\u007f\u0011y\u00031\u0001\u0002B!A!q\nB\u0018\u0001\u0004\u0011\t&\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a0\u0003T\t]\u0011\u0002\u0002B+\u0003\u0003\u00141aU3r\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057\n\u0001\u0003[1oI2,G*[:u\u000fJ|W\u000f]:\u0015\u0005\tu\u0003cB\u0005\u0002\u0002\n}#1\u000e\t\u0005\u0005C\u00129'\u0004\u0002\u0003d)\u0019!QM)\u0002\u0011A\u0014x\u000e^8d_2LAA!\u001b\u0003d\t1QI\u001d:peN\u0004b!!\u001b\u0002z\t5\u0004c\u0001\u0011\u0003p%\u0019!\u0011\u000f\u0002\u0003\u001b\u001d\u0013x.\u001e9Pm\u0016\u0014h/[3x\u0011\u001d\u0011)\b\u0001C\u0001\u0005o\n1\u0003[1oI2,G)Z:de&\u0014Wm\u0012:pkB$BA!\u001f\u0003\u0002B9\u0011\"!!\u0003`\tm\u0004c\u0001\u0011\u0003~%\u0019!q\u0010\u0002\u0003\u0019\u001d\u0013x.\u001e9Tk6l\u0017M]=\t\u0011\u0005}\"1\u000fa\u0001\u0003\u0003BqA!\"\u0001\t\u0013\u00119)A\bp]\u001e\u0013x.\u001e9V]2|\u0017\rZ3e)\ri'\u0011\u0012\u0005\t\u0003+\u0013\u0019\t1\u0001\u0002\u0018\"9!Q\u0012\u0001\u0005\n\t=\u0015!D8o\u000fJ|W\u000f\u001d'pC\u0012,G\rF\u0002n\u0005#C\u0001\"!&\u0003\f\u0002\u0007\u0011q\u0013\u0005\b\u0005+\u0003A\u0011\u0001BL\u0003YA\u0017M\u001c3mK\u001e\u0013x.\u001e9J[6LwM]1uS>tGcA7\u0003\u001a\"9!1\u0014BJ\u0001\u00049\u0012AF8gMN,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\u0006)\u0002.\u00198eY\u0016<%o\\;q\u000b6LwM]1uS>tGcA7\u0003$\"9!1\u0014BO\u0001\u00049\u0002b\u0002BT\u0001\u0011%!\u0011V\u0001\u001ag\u0016$\u0018I\u001c3Qe>\u0004\u0018mZ1uK\u0006\u001b8/[4o[\u0016tG\u000fF\u0003n\u0005W\u0013i\u000b\u0003\u0005\u0002\u0016\n\u0015\u0006\u0019AAL\u0011!\u0011yK!*A\u0002\u0005u\u0016AC1tg&<g.\\3oi\"9!1\u0017\u0001\u0005\n\tU\u0016\u0001\t:fg\u0016$\u0018I\u001c3Qe>\u0004\u0018mZ1uK\u0006\u001b8/[4o[\u0016tG/\u0012:s_J$R!\u001cB\\\u0005sC\u0001\"!&\u00032\u0002\u0007\u0011q\u0013\u0005\b\u0005w\u0013\t\f1\u0001|\u0003%)'O]8s\u0007>$W\rC\u0004\u0003@\u0002!IA!1\u0002'A\u0014x\u000e]1hCR,\u0017i]:jO:lWM\u001c;\u0015\u000b5\u0014\u0019M!2\t\u0011\u0005U%Q\u0018a\u0001\u0003/CqAa/\u0003>\u0002\u00071\u0010C\u0004\u0003J\u0002!IAa3\u0002\u0019Y\fG.\u001b3He>,\b/\u00133\u0015\t\t5'1\u001b\t\u0004\u0013\t=\u0017b\u0001Bi\u0015\t9!i\\8mK\u0006t\u0007\u0002CA \u0005\u000f\u0004\r!!\u0011\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\u0006I!n\\5o\u000bJ\u0014xN\u001d\u000b\u0006U\nm'Q\u001c\u0005\t\u0003#\u0012)\u000e1\u0001\u0002B!9!1\u0018Bk\u0001\u0004Y\bb\u0002Bq\u0001\u0011%!1]\u0001+G>l\u0007\u000f\\3uK\u0006sGmU2iK\u0012,H.\u001a(fqRDU-\u0019:uE\u0016\fG/\u0012=qSJ\fG/[8o)\u0015i'Q\u001dBt\u0011!\t)Ja8A\u0002\u0005]\u0005\u0002\u0003Bu\u0005?\u0004\rAa;\u0002\r5,WNY3s!\r\u0001#Q^\u0005\u0004\u0005_\u0014!AD'f[\n,'/T3uC\u0012\fG/\u0019\u0005\b\u0005g\u0004A\u0011\u0002B{\u0003}\u0011X-\\8wK\"+\u0017M\u001d;cK\u0006$hi\u001c:MK\u00064\u0018N\\4NK6\u0014WM\u001d\u000b\u0006[\n](\u0011 \u0005\t\u0003+\u0013\t\u00101\u0001\u0002\u0018\"A!\u0011\u001eBy\u0001\u0004\u0011Y\u000fC\u0004\u0003~\u0002!IAa@\u0002+\u0005$G-T3nE\u0016\u0014\u0018I\u001c3SK\n\fG.\u00198dKRq!1^B\u0001\u0007\u0007\u0019)aa\u0002\u0004\n\r-\u0001bBA/\u0005w\u0004\ra\u0006\u0005\t\u0003+\u0012Y\u00101\u0001\u0002B!A\u0011\u0011\fB~\u0001\u0004\t\t\u0005\u0003\u0005\u0002f\tm\b\u0019AA4\u0011!\t)Ja?A\u0002\u0005]\u0005\u0002CB\u0007\u0005w\u0004\r!!#\u0002\u0011\r\fG\u000e\u001c2bG.Dqa!\u0005\u0001\t\u0013\u0019\u0019\"\u0001\rva\u0012\fG/Z'f[\n,'/\u00118e%\u0016\u0014\u0017\r\\1oG\u0016$\u0012\"\\B\u000b\u0007/\u0019Iba\u0007\t\u0011\u0005U5q\u0002a\u0001\u0003/C\u0001B!;\u0004\u0010\u0001\u0007!1\u001e\u0005\t\u0003K\u001ay\u00011\u0001\u0002h!A1QBB\b\u0001\u0004\tI\tC\u0004\u0004 \u0001!Ia!\t\u0002+5\f\u0017PY3Qe\u0016\u0004\u0018M]3SK\n\fG.\u00198dKR\u0019Qna\t\t\u0011\u0005U5Q\u0004a\u0001\u0003/Cqaa\n\u0001\t\u0013\u0019I#\u0001\tqe\u0016\u0004\u0018M]3SK\n\fG.\u00198dKR\u0019Qna\u000b\t\u0011\u0005U5Q\u0005a\u0001\u0003/Cqaa\f\u0001\t\u0013\u0019\t$A\bp]6+WNY3s\r\u0006LG.\u001e:f)\u0015i71GB\u001b\u0011!\t)j!\fA\u0002\u0005]\u0005\u0002\u0003Bu\u0007[\u0001\rAa;\t\u000f\re\u0002\u0001\"\u0001\u0004<\u0005yAO]=D_6\u0004H.\u001a;f\u0015>Lg\u000e\u0006\u0004\u0003N\u000eu2q\b\u0005\t\u0003+\u001b9\u00041\u0001\u0002\u0018\"A1\u0011IB\u001c\u0001\u0004\u0019\u0019%A\u0007g_J\u001cWmQ8na2,G/\u001a\t\u0006\u0013\r\u0015#QZ\u0005\u0004\u0007\u000fR!!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0003c\tAb\u001c8FqBL'/\u001a&pS:Dqaa\u0014\u0001\t\u0003\u0019\t&\u0001\bp]\u000e{W\u000e\u001d7fi\u0016Tu.\u001b8\u0015\u00075\u001c\u0019\u0006\u0003\u0005\u0002\u0016\u000e5\u0003\u0019AAL\u0011\u001d\u00199\u0006\u0001C\u0001\u00073\nA\u0003\u001e:z\u0007>l\u0007\u000f\\3uK\"+\u0017M\u001d;cK\u0006$HC\u0003Bg\u00077\u001aifa\u0018\u0004j!A\u0011QSB+\u0001\u0004\t9\n\u0003\u0005\u0003j\u000eU\u0003\u0019\u0001Bv\u0011!\u0019\tg!\u0016A\u0002\r\r\u0014!\u00055fCJ$(-Z1u\t\u0016\fG\r\\5oKB\u0019\u0011b!\u001a\n\u0007\r\u001d$B\u0001\u0003M_:<\u0007\u0002CB!\u0007+\u0002\raa\u0011\t\u000f\r5\u0004\u0001\"\u0001\u0004p\u0005\trN\\#ya&\u0014X\rS3beR\u0014W-\u0019;\u0015\u000f5\u001c\tha\u001d\u0004v!A\u0011QSB6\u0001\u0004\t9\n\u0003\u0005\u0003j\u000e-\u0004\u0019\u0001Bv\u0011!\u0019\tga\u001bA\u0002\r\r\u0004bBB=\u0001\u0011\u0005\u0011\u0011G\u0001\u0014_:\u001cu.\u001c9mKR,\u0007*Z1si\n,\u0017\r\u001e\u0005\b\u0007{\u0002A\u0011AB@\u00031\u0001\u0018M\u001d;ji&|gNR8s)\r92\u0011\u0011\u0005\t\u0003+\u001bY\b1\u0001\u0002B!91Q\u0011\u0001\u0005\n\r\u001d\u0015!F:i_VdGmS3fa6+WNY3s\u00032Lg/\u001a\u000b\u0007\u0005\u001b\u001cIia#\t\u0011\t%81\u0011a\u0001\u0005WD\u0001b!\u0019\u0004\u0004\u0002\u000711\r\u0005\b\u0007\u001f\u0003A\u0011BBI\u0003UI7oQ8pe\u0012Lg.\u0019;pe\u001a{'o\u0012:pkB$BA!4\u0004\u0014\"A\u0011qHBG\u0001\u0004\t\t\u0005C\u0004\u0004\u0018\u0002!Ia!'\u0002=%\u001c8i\\8sI&t\u0017\r^8s\u0019>\fG-\u001b8h\u0013:\u0004&o\\4sKN\u001cH\u0003\u0002Bg\u00077C\u0001\"a\u0010\u0004\u0016\u0002\u0007\u0011\u0011I\u0004\b\u0007?\u0013\u0001\u0012ABQ\u0003A9%o\\;q\u0007>|'\u000fZ5oCR|'\u000fE\u0002!\u0007G3a!\u0001\u0002\t\u0002\r\u00156cABR\u0011!91la)\u0005\u0002\r%FCABQ\u0011)\u0019ika)C\u0002\u0013\u00051qV\u0001\b\u001d>\u001cF/\u0019;f+\t\u0019\t\f\u0005\u0003\u00044\u000eeVBAB[\u0015\u0011\u00199,a\u0005\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\u001a)\fC\u0005\u0004>\u000e\r\u0006\u0015!\u0003\u00042\u0006Aaj\\*uCR,\u0007\u0005\u0003\u0006\u0004B\u000e\r&\u0019!C\u0001\u0007_\u000baBT8Qe>$xnY8m)f\u0004X\rC\u0005\u0004F\u000e\r\u0006\u0015!\u0003\u00042\u0006yaj\u001c)s_R|7m\u001c7UsB,\u0007\u0005\u0003\u0006\u0004J\u000e\r&\u0019!C\u0001\u0007_\u000b!BT8Qe>$xnY8m\u0011%\u0019ima)!\u0002\u0013\u0019\t,A\u0006O_B\u0013x\u000e^8d_2\u0004\u0003BCBi\u0007G\u0013\r\u0011\"\u0001\u00040\u0006Aaj\u001c'fC\u0012,'\u000fC\u0005\u0004V\u000e\r\u0006\u0015!\u0003\u00042\u0006Iaj\u001c'fC\u0012,'\u000f\t\u0005\u000b\u00073\u001c\u0019K1A\u0005\u0002\rm\u0017!\u0003(p\u001b\u0016l'-\u001a:t+\t\u0019i\u000e\u0005\u0004\u0003\u0010\r}7\u0011]\u0005\u0005\u0003w\u0012\t\u0002E\u0002!\u0007GL1a!:\u0003\u00055iU-\u001c2feN+X.\\1ss\"I1\u0011^BRA\u0003%1Q\\\u0001\u000b\u001d>lU-\u001c2feN\u0004\u0003BCBw\u0007G\u0013\r\u0011\"\u0001\u0004p\u0006QQ)\u001c9us\u001e\u0013x.\u001e9\u0016\u0005\tm\u0004\"CBz\u0007G\u0003\u000b\u0011\u0002B>\u0003-)U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0011\t\u0015\r]81\u0015b\u0001\n\u0003\u0019y/A\u0005EK\u0006$wI]8va\"I11`BRA\u0003%!1P\u0001\u000b\t\u0016\fGm\u0012:pkB\u0004\u0003\u0002CB\u0000\u0007G#\t\u0001\"\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013u#\u0019\u0001\"\u0004\u0005\u0018\u0011\u0005\u0002\u0002\u0003C\u0003\u0007{\u0004\r\u0001b\u0002\u0002\r\r|gNZ5h!\rID\u0011B\u0005\u0004\t\u0017Q$aC&bM.\f7i\u001c8gS\u001eD\u0001\u0002b\u0004\u0004~\u0002\u0007A\u0011C\u0001\bu.,F/\u001b7t!\ryA1C\u0005\u0004\t+\u0001\"a\u0002.l+RLGn\u001d\u0005\t\t3\u0019i\u00101\u0001\u0005\u001c\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bcA\u001d\u0005\u001e%\u0019Aq\u0004\u001e\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"1Qj!@A\u00029C\u0001ba@\u0004$\u0012\u0005AQ\u0005\u000b\u000e;\u0012\u001dB\u0011\u0006C\u0016\t[!y\u0003\"\r\t\u0011\u0011\u0015A1\u0005a\u0001\t\u000fA\u0001\u0002b\u0004\u0005$\u0001\u0007A\u0011\u0003\u0005\t\t3!\u0019\u00031\u0001\u0005\u001c!1a\u0007b\tA\u0002aBa\u0001\u0012C\u0012\u0001\u00041\u0005BB'\u0005$\u0001\u0007a\n")
public class GroupCoordinator
implements Logging {
    private final int brokerId;
    private final GroupConfig groupConfig;
    private final OffsetConfig offsetConfig;
    private final GroupMetadataManager groupManager;
    private final DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory;
    private final DelayedOperationPurgatory<DelayedJoin> joinPurgatory;
    private final Time time;
    private final AtomicBoolean isActive;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static GroupCoordinator apply(KafkaConfig kafkaConfig, ZkUtils zkUtils, ReplicaManager replicaManager, DelayedOperationPurgatory<DelayedHeartbeat> delayedOperationPurgatory, DelayedOperationPurgatory<DelayedJoin> delayedOperationPurgatory2, Time time) {
        return GroupCoordinator$.MODULE$.apply(kafkaConfig, zkUtils, replicaManager, delayedOperationPurgatory, delayedOperationPurgatory2, time);
    }

    public static GroupCoordinator apply(KafkaConfig kafkaConfig, ZkUtils zkUtils, ReplicaManager replicaManager, Time time) {
        return GroupCoordinator$.MODULE$.apply(kafkaConfig, zkUtils, replicaManager, time);
    }

    public static GroupSummary DeadGroup() {
        return GroupCoordinator$.MODULE$.DeadGroup();
    }

    public static GroupSummary EmptyGroup() {
        return GroupCoordinator$.MODULE$.EmptyGroup();
    }

    public static List<MemberSummary> NoMembers() {
        return GroupCoordinator$.MODULE$.NoMembers();
    }

    public static String NoLeader() {
        return GroupCoordinator$.MODULE$.NoLeader();
    }

    public static String NoProtocol() {
        return GroupCoordinator$.MODULE$.NoProtocol();
    }

    public static String NoProtocolType() {
        return GroupCoordinator$.MODULE$.NoProtocolType();
    }

    public static String NoState() {
        return GroupCoordinator$.MODULE$.NoState();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        GroupCoordinator groupCoordinator = this;
        synchronized (groupCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public GroupConfig groupConfig() {
        return this.groupConfig;
    }

    public OffsetConfig offsetConfig() {
        return this.offsetConfig;
    }

    public GroupMetadataManager groupManager() {
        return this.groupManager;
    }

    public DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory() {
        return this.heartbeatPurgatory;
    }

    public DelayedOperationPurgatory<DelayedJoin> joinPurgatory() {
        return this.joinPurgatory;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - void declaration
     */
    public Properties offsetsTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.offsetConfig().offsetsTopicSegmentBytes())).toString());
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        return var1_1;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting up.";
            }
        });
        this.isActive().set(true);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Startup complete.";
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down.";
            }
        });
        this.isActive().set(false);
        this.groupManager().shutdown();
        this.heartbeatPurgatory().shutdown();
        this.joinPurgatory().shutdown();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown complete.";
            }
        });
    }

    public void handleJoinGroup(String groupId, String memberId, String clientId, String clientHost, int sessionTimeoutMs, String protocolType, List<Tuple2<String, byte[]>> protocols2, Function1<JoinGroupResult, BoxedUnit> responseCallback) {
        if (this.isActive().get()) {
            if (this.validGroupId(groupId)) {
                if (this.isCoordinatorForGroup(groupId)) {
                    if (this.isCoordinatorLoadingInProgress(groupId)) {
                        responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.GROUP_LOAD_IN_PROGRESS.code()));
                    } else if (sessionTimeoutMs < this.groupConfig().groupMinSessionTimeoutMs() || sessionTimeoutMs > this.groupConfig().groupMaxSessionTimeoutMs()) {
                        responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.INVALID_SESSION_TIMEOUT.code()));
                    } else {
                        GroupMetadata group = this.groupManager().getGroup(groupId);
                        if (group == null) {
                            String string = memberId;
                            String string2 = "";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                group = this.groupManager().addGroup(new GroupMetadata(groupId, protocolType));
                                this.doJoinGroup(group, memberId, clientId, clientHost, sessionTimeoutMs, protocolType, protocols2, responseCallback);
                            } else {
                                responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.UNKNOWN_MEMBER_ID.code()));
                            }
                        } else {
                            this.doJoinGroup(group, memberId, clientId, clientHost, sessionTimeoutMs, protocolType, protocols2, responseCallback);
                        }
                    }
                } else {
                    responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.NOT_COORDINATOR_FOR_GROUP.code()));
                }
            } else {
                responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.INVALID_GROUP_ID.code()));
            }
        } else {
            responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doJoinGroup(GroupMetadata group, String memberId, String clientId, String clientHost, int sessionTimeoutMs, String protocolType, List<Tuple2<String, byte[]>> protocols2, Function1<JoinGroupResult, BoxedUnit> responseCallback) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            Object object;
            String string = group.protocolType();
            String string2 = protocolType;
            if (!(string != null ? !string.equals(string2) : string2 != null) && group.supportsProtocols((scala.collection.immutable.Set<String>)((TraversableOnce)protocols2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, byte[]> x$1) {
                    return (String)x$1._1();
                }
            }, List$.MODULE$.canBuildFrom())).toSet())) {
                String string3 = memberId;
                String string4 = "";
                if (!(string3 == null ? string4 != null : !string3.equals(string4)) || group.has(memberId)) {
                    Object object2;
                    GroupState groupState = group.currentState();
                    if (Dead$.MODULE$.equals(groupState)) {
                        object2 = responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.UNKNOWN_MEMBER_ID.code()));
                    } else if (PreparingRebalance$.MODULE$.equals(groupState)) {
                        MemberMetadata memberMetadata;
                        String string5 = memberId;
                        String string6 = "";
                        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                            memberMetadata = this.addMemberAndRebalance(sessionTimeoutMs, clientId, clientHost, protocols2, group, responseCallback);
                        } else {
                            MemberMetadata member = group.get(memberId);
                            this.updateMemberAndRebalance(group, member, protocols2, responseCallback);
                            memberMetadata = BoxedUnit.UNIT;
                        }
                        object2 = memberMetadata;
                    } else if (AwaitingSync$.MODULE$.equals(groupState)) {
                        Object object3;
                        String string7 = memberId;
                        String string8 = "";
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            object3 = this.addMemberAndRebalance(sessionTimeoutMs, clientId, clientHost, protocols2, group, responseCallback);
                        } else {
                            MemberMetadata member = group.get(memberId);
                            if (member.matches(protocols2)) {
                                String string9 = memberId;
                                String string10 = group.leaderId();
                                object3 = responseCallback.apply((Object)new JoinGroupResult((Map<String, byte[]>)(!(string9 != null ? !string9.equals(string10) : string10 != null) ? group.currentMemberMetadata() : Map$.MODULE$.empty()), memberId, group.generationId(), group.protocol(), group.leaderId(), Errors.NONE.code()));
                            } else {
                                this.updateMemberAndRebalance(group, member, protocols2, responseCallback);
                                object3 = BoxedUnit.UNIT;
                            }
                        }
                        object2 = object3;
                    } else {
                        Object object4;
                        if (!Stable$.MODULE$.equals(groupState)) throw new MatchError((Object)groupState);
                        String string11 = memberId;
                        String string12 = "";
                        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                            object4 = this.addMemberAndRebalance(sessionTimeoutMs, clientId, clientHost, protocols2, group, responseCallback);
                        } else {
                            MemberMetadata member = group.get(memberId);
                            String string13 = memberId;
                            String string14 = group.leaderId();
                            if ((string13 == null ? string14 != null : !string13.equals(string14)) && member.matches(protocols2)) {
                                object4 = responseCallback.apply((Object)new JoinGroupResult((Map<String, byte[]>)Map$.MODULE$.empty(), memberId, group.generationId(), group.protocol(), group.leaderId(), Errors.NONE.code()));
                            } else {
                                this.updateMemberAndRebalance(group, member, protocols2, responseCallback);
                                object4 = BoxedUnit.UNIT;
                            }
                        }
                        object2 = object4;
                    }
                    object = group.is(PreparingRebalance$.MODULE$) ? BoxesRunTime.boxToInteger((int)this.joinPurgatory().checkAndComplete(new GroupKey(group.groupId()))) : BoxedUnit.UNIT;
                } else {
                    object = responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.UNKNOWN_MEMBER_ID.code()));
                }
            } else {
                object = responseCallback.apply((Object)this.kafka$coordinator$GroupCoordinator$$joinError(memberId, Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
            }
            return;
        }
    }

    public void handleSyncGroup(String groupId, int generation, String memberId, Map<String, byte[]> groupAssignment, Function2<byte[], Object, BoxedUnit> responseCallback) {
        if (this.isActive().get()) {
            if (this.isCoordinatorForGroup(groupId)) {
                GroupMetadata group = this.groupManager().getGroup(groupId);
                if (group == null) {
                    responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
                } else {
                    this.doSyncGroup(group, generation, memberId, groupAssignment, responseCallback);
                }
            } else {
                responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.NOT_COORDINATOR_FOR_GROUP.code()));
            }
        } else {
            responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSyncGroup(GroupMetadata group, int generationId, String memberId, Map<String, byte[]> groupAssignment, Function2<byte[], Object, BoxedUnit> responseCallback) {
        None$ delayedGroupStore = None$.MODULE$;
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            Object object;
            if (group.has(memberId)) {
                if (generationId != group.generationId()) {
                    object = responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.ILLEGAL_GENERATION.code()));
                } else {
                    GroupState groupState = group.currentState();
                    if (Dead$.MODULE$.equals(groupState)) {
                        BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
                    } else if (PreparingRebalance$.MODULE$.equals(groupState)) {
                        BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.REBALANCE_IN_PROGRESS.code()));
                    } else if (AwaitingSync$.MODULE$.equals(groupState)) {
                        BoxedUnit boxedUnit;
                        group.get(memberId).awaitingSyncCallback_$eq(responseCallback);
                        this.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(group, group.get(memberId));
                        String string = memberId;
                        String string2 = group.leaderId();
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            this.info((Function0<String>)new Serializable(this, group){
                                public static final long serialVersionUID = 0L;
                                private final GroupMetadata group$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment received from leader for group ", " for generation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$2.groupId(), BoxesRunTime.boxToInteger((int)this.group$2.generationId())}));
                                }
                                {
                                    this.group$2 = group$2;
                                }
                            });
                            Set missing = (Set)group.allMembers().$minus$minus((GenTraversableOnce)groupAssignment.keySet());
                            Map assignment = groupAssignment.$plus$plus((GenTraversableOnce)((TraversableOnce)missing.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, byte[]> apply(String x$2) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$2), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
                                }
                            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                            delayedGroupStore = new Some((Object)this.groupManager().prepareStoreGroup(group, (Map<String, byte[]>)assignment, (Function1<Object, BoxedUnit>)new Serializable(this, group, generationId, assignment){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ GroupCoordinator $outer;
                                private final GroupMetadata group$2;
                                private final int generationId$1;
                                private final Map assignment$1;

                                public final void apply(short errorCode) {
                                    GroupMetadata groupMetadata = this.group$2;
                                    synchronized (groupMetadata) {
                                        BoxedUnit boxedUnit;
                                        if (this.group$2.is(AwaitingSync$.MODULE$) && this.generationId$1 == this.group$2.generationId()) {
                                            if (errorCode != Errors.NONE.code()) {
                                                this.$outer.kafka$coordinator$GroupCoordinator$$resetAndPropagateAssignmentError(this.group$2, errorCode);
                                                this.$outer.kafka$coordinator$GroupCoordinator$$maybePrepareRebalance(this.group$2);
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                this.$outer.kafka$coordinator$GroupCoordinator$$setAndPropagateAssignment(this.group$2, (Map<String, byte[]>)this.assignment$1);
                                                this.group$2.transitionTo(Stable$.MODULE$);
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                        } else {
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        return;
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.group$2 = group$2;
                                    this.generationId$1 = generationId$1;
                                    this.assignment$1 = assignment$1;
                                }
                            }));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        if (!Stable$.MODULE$.equals(groupState)) {
                            throw new MatchError((Object)groupState);
                        }
                        MemberMetadata memberMetadata = group.get(memberId);
                        responseCallback.apply((Object)memberMetadata.assignment(), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                        this.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(group, group.get(memberId));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = responseCallback.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
            }
        }
        delayedGroupStore.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupCoordinator $outer;

            public final void apply(DelayedStore delayedAppend) {
                this.$outer.groupManager().store(delayedAppend);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleLeaveGroup(String groupId, String consumerId, Function1<Object, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code()));
            return;
        }
        if (!this.isCoordinatorForGroup(groupId)) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.NOT_COORDINATOR_FOR_GROUP.code()));
            return;
        }
        if (this.isCoordinatorLoadingInProgress(groupId)) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.GROUP_LOAD_IN_PROGRESS.code()));
            return;
        }
        GroupMetadata group = this.groupManager().getGroup(groupId);
        if (group == null) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
            return;
        }
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            Object object;
            if (group.is(Dead$.MODULE$)) {
                object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
            } else if (group.has(consumerId)) {
                MemberMetadata member = group.get(consumerId);
                this.removeHeartbeatForLeavingMember(group, member);
                this.onMemberFailure(group, member);
                object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
            } else {
                object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleHeartbeat(String groupId, String memberId, int generationId, Function1<Object, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code()));
            return;
        }
        if (!this.isCoordinatorForGroup(groupId)) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.NOT_COORDINATOR_FOR_GROUP.code()));
            return;
        }
        if (this.isCoordinatorLoadingInProgress(groupId)) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
            return;
        }
        GroupMetadata group = this.groupManager().getGroup(groupId);
        if (group == null) {
            responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
            return;
        }
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            block11: {
                Object object;
                block13: {
                    block12: {
                        if (!group.is(Dead$.MODULE$)) break block12;
                        object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
                        break block11;
                    }
                    if (!group.is(Stable$.MODULE$)) break block13;
                    if (group.has(memberId)) {
                        if (generationId != group.generationId()) {
                            object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.ILLEGAL_GENERATION.code()));
                            break block11;
                        } else {
                            MemberMetadata member = group.get(memberId);
                            this.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(group, member);
                            object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                        }
                        break block11;
                    } else {
                        object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_MEMBER_ID.code()));
                    }
                    break block11;
                }
                object = responseCallback.apply((Object)BoxesRunTime.boxToShort((short)Errors.REBALANCE_IN_PROGRESS.code()));
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCommitOffsets(String groupId, String memberId, int generationId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsetMetadata, Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit> responseCallback) {
        None$ delayedOffsetStore;
        block15: {
            Object object;
            block17: {
                block18: {
                    block19: {
                        delayedOffsetStore = None$.MODULE$;
                        if (!this.isActive().get()) break block17;
                        if (!this.isCoordinatorForGroup(groupId)) break block18;
                        if (!this.isCoordinatorLoadingInProgress(groupId)) break block19;
                        object = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final short apply(OffsetAndMetadata x$5) {
                                return Errors.GROUP_LOAD_IN_PROGRESS.code();
                            }
                        }));
                        break block15;
                    }
                    GroupMetadata group = this.groupManager().getGroup(groupId);
                    if (group == null) {
                        if (generationId < 0) {
                            delayedOffsetStore = new Some((Object)this.groupManager().prepareStoreOffsets(groupId, memberId, generationId, offsetMetadata, responseCallback));
                            object = BoxedUnit.UNIT;
                            break block15;
                        } else {
                            object = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final short apply(OffsetAndMetadata x$6) {
                                    return Errors.ILLEGAL_GENERATION.code();
                                }
                            }));
                        }
                        break block15;
                    } else {
                        GroupMetadata groupMetadata = group;
                        synchronized (groupMetadata) {
                            Object object2;
                            if (group.is(Dead$.MODULE$)) {
                                object2 = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final short apply(OffsetAndMetadata x$7) {
                                        return Errors.UNKNOWN_MEMBER_ID.code();
                                    }
                                }));
                            } else if (group.is(AwaitingSync$.MODULE$)) {
                                object2 = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final short apply(OffsetAndMetadata x$8) {
                                        return Errors.REBALANCE_IN_PROGRESS.code();
                                    }
                                }));
                            } else if (group.has(memberId)) {
                                if (generationId != group.generationId()) {
                                    object2 = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final short apply(OffsetAndMetadata x$10) {
                                            return Errors.ILLEGAL_GENERATION.code();
                                        }
                                    }));
                                } else {
                                    MemberMetadata member = group.get(memberId);
                                    this.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(group, member);
                                    delayedOffsetStore = new Some((Object)this.groupManager().prepareStoreOffsets(groupId, memberId, generationId, offsetMetadata, responseCallback));
                                    object2 = BoxedUnit.UNIT;
                                }
                            } else {
                                object2 = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final short apply(OffsetAndMetadata x$9) {
                                        return Errors.UNKNOWN_MEMBER_ID.code();
                                    }
                                }));
                            }
                            Object object3 = object2;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 13] lbl35 : MonitorExitStatement: MONITOREXIT : var8_8
                            object = object3;
                        }
                    }
                }
                object = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final short apply(OffsetAndMetadata x$4) {
                        return Errors.NOT_COORDINATOR_FOR_GROUP.code();
                    }
                }));
                break block15;
            }
            object = responseCallback.apply((Object)offsetMetadata.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final short apply(OffsetAndMetadata x$3) {
                    return Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code();
                }
            }));
        }
        delayedOffsetStore.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupCoordinator $outer;

            public final void apply(DelayedStore delayedAppend) {
                this.$outer.groupManager().store(delayedAppend);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Map<TopicPartition, OffsetFetchResponse.PartitionData> handleFetchOffsets(String groupId, Seq<TopicPartition> partitions) {
        return this.isActive().get() ? (this.isCoordinatorForGroup(groupId) ? (this.isCoordinatorLoadingInProgress(groupId) ? ((TraversableOnce)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetFetchResponse.PartitionData> apply(TopicPartition x0$3) {
                TopicPartition topicPartition = x0$3;
                Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)new OffsetFetchResponse.PartitionData(-1L, "", Errors.GROUP_LOAD_IN_PROGRESS.code()));
                return tuple2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : this.groupManager().getOffsets(groupId, partitions)) : ((TraversableOnce)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetFetchResponse.PartitionData> apply(TopicPartition x0$2) {
                TopicPartition topicPartition = x0$2;
                Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)new OffsetFetchResponse.PartitionData(-1L, "", Errors.NOT_COORDINATOR_FOR_GROUP.code()));
                return tuple2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())) : ((TraversableOnce)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetFetchResponse.PartitionData> apply(TopicPartition x0$1) {
                TopicPartition topicPartition = x0$1;
                Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)new OffsetFetchResponse.PartitionData(-1L, "", Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code()));
                return tuple2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<Errors, List<GroupOverview>> handleListGroups() {
        Tuple2 tuple2;
        if (this.isActive().get()) {
            Errors errorCode = this.groupManager().isLoading() ? Errors.GROUP_LOAD_IN_PROGRESS : Errors.NONE;
            tuple2 = new Tuple2((Object)errorCode, (Object)((TraversableOnce)this.groupManager().currentGroups().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final GroupOverview apply(GroupMetadata x$11) {
                    return x$11.overview();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList());
        } else {
            tuple2 = new Tuple2((Object)Errors.GROUP_COORDINATOR_NOT_AVAILABLE, (Object)Nil$.MODULE$);
        }
        return tuple2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Errors, GroupSummary> handleDescribeGroup(String groupId) {
        Tuple2 tuple2;
        if (!this.isActive().get()) {
            tuple2 = new Tuple2((Object)Errors.GROUP_COORDINATOR_NOT_AVAILABLE, (Object)GroupCoordinator$.MODULE$.EmptyGroup());
            return tuple2;
        }
        if (!this.isCoordinatorForGroup(groupId)) {
            tuple2 = new Tuple2((Object)Errors.NOT_COORDINATOR_FOR_GROUP, (Object)GroupCoordinator$.MODULE$.EmptyGroup());
            return tuple2;
        }
        if (this.isCoordinatorLoadingInProgress(groupId)) {
            tuple2 = new Tuple2((Object)Errors.GROUP_LOAD_IN_PROGRESS, (Object)GroupCoordinator$.MODULE$.EmptyGroup());
            return tuple2;
        }
        GroupMetadata group = this.groupManager().getGroup(groupId);
        if (group == null) {
            tuple2 = new Tuple2((Object)Errors.NONE, (Object)GroupCoordinator$.MODULE$.DeadGroup());
            return tuple2;
        }
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            Tuple2 tuple22 = new Tuple2((Object)Errors.NONE, (Object)group.summary());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl18 : MonitorExitStatement: MONITOREXIT : groupMetadata
            tuple2 = tuple22;
            return tuple2;
        }
    }

    public void kafka$coordinator$GroupCoordinator$$onGroupUnloaded(GroupMetadata group) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            GroupState groupState;
            block8: {
                block6: {
                    Object object;
                    block7: {
                        block5: {
                            this.info((Function0<String>)new Serializable(this, group){
                                public static final long serialVersionUID = 0L;
                                private final GroupMetadata group$4;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unloading group metadata for ", " with generation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$4.groupId(), BoxesRunTime.boxToInteger((int)this.group$4.generationId())}));
                                }
                                {
                                    this.group$4 = group$4;
                                }
                            });
                            GroupState previousState = group.currentState();
                            group.transitionTo(Dead$.MODULE$);
                            groupState = previousState;
                            if (!Dead$.MODULE$.equals(groupState)) break block5;
                            object = BoxedUnit.UNIT;
                            break block6;
                        }
                        if (!PreparingRebalance$.MODULE$.equals(groupState)) break block7;
                        group.allMemberMetadata().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ GroupCoordinator $outer;

                            public final void apply(MemberMetadata member) {
                                if (member.awaitingJoinCallback() != null) {
                                    member.awaitingJoinCallback().apply((Object)this.$outer.kafka$coordinator$GroupCoordinator$$joinError(member.memberId(), Errors.NOT_COORDINATOR_FOR_GROUP.code()));
                                    member.awaitingJoinCallback_$eq(null);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        object = BoxesRunTime.boxToInteger((int)this.joinPurgatory().checkAndComplete(new GroupKey(group.groupId())));
                        break block6;
                    }
                    boolean bl = Stable$.MODULE$.equals(groupState) ? true : AwaitingSync$.MODULE$.equals(groupState);
                    if (!bl) break block8;
                    group.allMemberMetadata().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ GroupCoordinator $outer;

                        public final int apply(MemberMetadata member) {
                            if (member.awaitingSyncCallback() != null) {
                                member.awaitingSyncCallback().apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Object)BoxesRunTime.boxToShort((short)Errors.NOT_COORDINATOR_FOR_GROUP.code()));
                                member.awaitingSyncCallback_$eq(null);
                            }
                            return this.$outer.heartbeatPurgatory().checkAndComplete(new MemberKey(member.groupId(), member.memberId()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    object = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)groupState);
        }
    }

    public void kafka$coordinator$GroupCoordinator$$onGroupLoaded(GroupMetadata group) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            this.info((Function0<String>)new Serializable(this, group){
                public static final long serialVersionUID = 0L;
                private final GroupMetadata group$5;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading group metadata for ", " with generation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$5.groupId(), BoxesRunTime.boxToInteger((int)this.group$5.generationId())}));
                }
                {
                    this.group$5 = group$5;
                }
            });
            Predef$.MODULE$.assert(group.is(Stable$.MODULE$));
            group.allMemberMetadata().foreach((Function1)new Serializable(this, group){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupCoordinator $outer;
                private final GroupMetadata group$5;

                public final void apply(MemberMetadata x$12) {
                    this.$outer.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(this.group$5, x$12);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.group$5 = group$5;
                }
            });
            return;
        }
    }

    public void handleGroupImmigration(int offsetTopicPartitionId) {
        this.groupManager().loadGroupsForPartition(offsetTopicPartitionId, (Function1<GroupMetadata, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupCoordinator $outer;

            public final void apply(GroupMetadata group) {
                this.$outer.kafka$coordinator$GroupCoordinator$$onGroupLoaded(group);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleGroupEmigration(int offsetTopicPartitionId) {
        this.groupManager().removeGroupsForPartition(offsetTopicPartitionId, (Function1<GroupMetadata, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupCoordinator $outer;

            public final void apply(GroupMetadata group) {
                this.$outer.kafka$coordinator$GroupCoordinator$$onGroupUnloaded(group);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$coordinator$GroupCoordinator$$setAndPropagateAssignment(GroupMetadata group, Map<String, byte[]> assignment) {
        Predef$.MODULE$.assert(group.is(AwaitingSync$.MODULE$));
        group.allMemberMetadata().foreach((Function1)new Serializable(this, assignment){
            public static final long serialVersionUID = 0L;
            private final Map assignment$2;

            public final void apply(MemberMetadata member) {
                member.assignment_$eq((byte[])this.assignment$2.apply((Object)member.memberId()));
            }
            {
                this.assignment$2 = assignment$2;
            }
        });
        this.propagateAssignment(group, Errors.NONE.code());
    }

    public void kafka$coordinator$GroupCoordinator$$resetAndPropagateAssignmentError(GroupMetadata group, short errorCode) {
        Predef$.MODULE$.assert(group.is(AwaitingSync$.MODULE$));
        group.allMemberMetadata().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MemberMetadata x$13) {
                x$13.assignment_$eq((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        this.propagateAssignment(group, errorCode);
    }

    private void propagateAssignment(GroupMetadata group, short errorCode) {
        group.allMemberMetadata().foreach((Function1)new Serializable(this, group, errorCode){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupCoordinator $outer;
            private final GroupMetadata group$6;
            private final short errorCode$1;

            public final void apply(MemberMetadata member) {
                if (member.awaitingSyncCallback() != null) {
                    member.awaitingSyncCallback().apply((Object)member.assignment(), (Object)BoxesRunTime.boxToShort((short)this.errorCode$1));
                    member.awaitingSyncCallback_$eq(null);
                    this.$outer.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(this.group$6, member);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.group$6 = group$6;
                this.errorCode$1 = errorCode$1;
            }
        });
    }

    private boolean validGroupId(String groupId) {
        return groupId != null && !groupId.isEmpty();
    }

    public JoinGroupResult kafka$coordinator$GroupCoordinator$$joinError(String memberId, short errorCode) {
        return new JoinGroupResult((Map<String, byte[]>)Map$.MODULE$.empty(), memberId, 0, GroupCoordinator$.MODULE$.NoProtocol(), GroupCoordinator$.MODULE$.NoLeader(), errorCode);
    }

    public void kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(GroupMetadata group, MemberMetadata member) {
        member.latestHeartbeat_$eq(this.time.milliseconds());
        MemberKey memberKey = new MemberKey(member.groupId(), member.memberId());
        this.heartbeatPurgatory().checkAndComplete(memberKey);
        long newHeartbeatDeadline = member.latestHeartbeat() + (long)member.sessionTimeoutMs();
        DelayedHeartbeat delayedHeartbeat = new DelayedHeartbeat(this, group, member, newHeartbeatDeadline, member.sessionTimeoutMs());
        this.heartbeatPurgatory().tryCompleteElseWatch(delayedHeartbeat, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MemberKey[]{memberKey}))));
    }

    private void removeHeartbeatForLeavingMember(GroupMetadata group, MemberMetadata member) {
        member.isLeaving_$eq(true);
        MemberKey memberKey = new MemberKey(member.groupId(), member.memberId());
        this.heartbeatPurgatory().checkAndComplete(memberKey);
    }

    private MemberMetadata addMemberAndRebalance(int sessionTimeoutMs, String clientId, String clientHost, List<Tuple2<String, byte[]>> protocols2, GroupMetadata group, Function1<JoinGroupResult, BoxedUnit> callback) {
        String memberId = new StringBuilder().append((Object)clientId).append((Object)"-").append((Object)group.generateMemberIdSuffix()).toString();
        MemberMetadata member = new MemberMetadata(memberId, group.groupId(), clientId, clientHost, sessionTimeoutMs, protocols2);
        member.awaitingJoinCallback_$eq(callback);
        group.add(member.memberId(), member);
        this.kafka$coordinator$GroupCoordinator$$maybePrepareRebalance(group);
        return member;
    }

    private void updateMemberAndRebalance(GroupMetadata group, MemberMetadata member, List<Tuple2<String, byte[]>> protocols2, Function1<JoinGroupResult, BoxedUnit> callback) {
        member.supportedProtocols_$eq(protocols2);
        member.awaitingJoinCallback_$eq(callback);
        this.kafka$coordinator$GroupCoordinator$$maybePrepareRebalance(group);
    }

    public void kafka$coordinator$GroupCoordinator$$maybePrepareRebalance(GroupMetadata group) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            BoxedUnit boxedUnit;
            if (group.canRebalance()) {
                this.prepareRebalance(group);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private void prepareRebalance(GroupMetadata group) {
        if (group.is(AwaitingSync$.MODULE$)) {
            this.kafka$coordinator$GroupCoordinator$$resetAndPropagateAssignmentError(group, Errors.REBALANCE_IN_PROGRESS.code());
        }
        group.transitionTo(PreparingRebalance$.MODULE$);
        this.info((Function0<String>)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$7;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Preparing to restabilize group %s with old generation %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$7.groupId(), BoxesRunTime.boxToInteger((int)this.group$7.generationId())}));
            }
            {
                this.group$7 = group$7;
            }
        });
        int rebalanceTimeout2 = group.rebalanceTimeout();
        DelayedJoin delayedRebalance = new DelayedJoin(this, group, rebalanceTimeout2);
        GroupKey groupKey = new GroupKey(group.groupId());
        this.joinPurgatory().tryCompleteElseWatch(delayedRebalance, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupKey[]{groupKey}))));
    }

    private void onMemberFailure(GroupMetadata group, MemberMetadata member) {
        GroupState groupState;
        block5: {
            block3: {
                block4: {
                    block2: {
                        this.trace((Function0<String>)new Serializable(this, group, member){
                            public static final long serialVersionUID = 0L;
                            private final GroupMetadata group$3;
                            private final MemberMetadata member$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Member %s in group %s has failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.member$1.memberId(), this.group$3.groupId()}));
                            }
                            {
                                this.group$3 = group$3;
                                this.member$1 = member$1;
                            }
                        });
                        group.remove(member.memberId());
                        groupState = group.currentState();
                        if (!Dead$.MODULE$.equals(groupState)) break block2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    boolean bl = Stable$.MODULE$.equals(groupState) ? true : AwaitingSync$.MODULE$.equals(groupState);
                    if (!bl) break block4;
                    this.kafka$coordinator$GroupCoordinator$$maybePrepareRebalance(group);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!PreparingRebalance$.MODULE$.equals(groupState)) break block5;
                this.joinPurgatory().checkAndComplete(new GroupKey(group.groupId()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)groupState);
    }

    public boolean tryCompleteJoin(GroupMetadata group, Function0<Object> forceComplete) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            Boolean bl = group.notYetRejoinedMembers().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)forceComplete.apply$mcZ$sp()) : BoxesRunTime.boxToBoolean((boolean)false);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void onExpireJoin() {
    }

    public void onCompleteJoin(GroupMetadata group) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            BoxedUnit boxedUnit;
            List<MemberMetadata> failedMembers = group.notYetRejoinedMembers();
            if (group.isEmpty() || !failedMembers.isEmpty()) {
                failedMembers.foreach((Function1)new Serializable(this, group){
                    public static final long serialVersionUID = 0L;
                    private final GroupMetadata group$1;

                    public final void apply(MemberMetadata failedMember) {
                        this.group$1.remove(failedMember.memberId());
                    }
                    {
                        this.group$1 = group$1;
                    }
                });
                if (group.isEmpty()) {
                    group.transitionTo(Dead$.MODULE$);
                    this.groupManager().removeGroup(group);
                    this.info((Function0<String>)new Serializable(this, group){
                        public static final long serialVersionUID = 0L;
                        private final GroupMetadata group$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Group %s generation %s is dead and removed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$1.groupId(), BoxesRunTime.boxToInteger((int)this.group$1.generationId())}));
                        }
                        {
                            this.group$1 = group$1;
                        }
                    });
                }
            }
            if (group.is(Dead$.MODULE$)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                group.initNextGeneration();
                this.info((Function0<String>)new Serializable(this, group){
                    public static final long serialVersionUID = 0L;
                    private final GroupMetadata group$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Stabilized group %s generation %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$1.groupId(), BoxesRunTime.boxToInteger((int)this.group$1.generationId())}));
                    }
                    {
                        this.group$1 = group$1;
                    }
                });
                group.allMemberMetadata().foreach((Function1)new Serializable(this, group){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GroupCoordinator $outer;
                    private final GroupMetadata group$1;

                    public final void apply(MemberMetadata member) {
                        Predef$.MODULE$.assert(member.awaitingJoinCallback() != null);
                        String string = member.memberId();
                        String string2 = this.group$1.leaderId();
                        JoinGroupResult joinResult = new JoinGroupResult((Map<String, byte[]>)(!(string != null ? !string.equals(string2) : string2 != null) ? this.group$1.currentMemberMetadata() : Map$.MODULE$.empty()), member.memberId(), this.group$1.generationId(), this.group$1.protocol(), this.group$1.leaderId(), Errors.NONE.code());
                        member.awaitingJoinCallback().apply((Object)joinResult);
                        member.awaitingJoinCallback_$eq(null);
                        this.$outer.kafka$coordinator$GroupCoordinator$$completeAndScheduleNextHeartbeatExpiration(this.group$1, member);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.group$1 = group$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean tryCompleteHeartbeat(GroupMetadata group, MemberMetadata member, long heartbeatDeadline, Function0<Object> forceComplete) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            Boolean bl = this.shouldKeepMemberAlive(member, heartbeatDeadline) || member.isLeaving() ? BoxesRunTime.boxToBoolean((boolean)forceComplete.apply$mcZ$sp()) : BoxesRunTime.boxToBoolean((boolean)false);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void onExpireHeartbeat(GroupMetadata group, MemberMetadata member, long heartbeatDeadline) {
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            BoxedUnit boxedUnit;
            if (this.shouldKeepMemberAlive(member, heartbeatDeadline)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.onMemberFailure(group, member);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void onCompleteHeartbeat() {
    }

    public int partitionFor(String group) {
        return this.groupManager().partitionFor(group);
    }

    private boolean shouldKeepMemberAlive(MemberMetadata member, long heartbeatDeadline) {
        return member.awaitingJoinCallback() != null || member.awaitingSyncCallback() != null || member.latestHeartbeat() + (long)member.sessionTimeoutMs() > heartbeatDeadline;
    }

    private boolean isCoordinatorForGroup(String groupId) {
        return this.groupManager().isGroupLocal(groupId);
    }

    private boolean isCoordinatorLoadingInProgress(String groupId) {
        return this.groupManager().isGroupLoading(groupId);
    }

    public GroupCoordinator(int brokerId, GroupConfig groupConfig, OffsetConfig offsetConfig, GroupMetadataManager groupManager, DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory, DelayedOperationPurgatory<DelayedJoin> joinPurgatory, Time time) {
        this.brokerId = brokerId;
        this.groupConfig = groupConfig;
        this.offsetConfig = offsetConfig;
        this.groupManager = groupManager;
        this.heartbeatPurgatory = heartbeatPurgatory;
        this.joinPurgatory = joinPurgatory;
        this.time = time;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[GroupCoordinator ").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).append((Object)"]: ").toString());
        this.isActive = new AtomicBoolean(false);
    }
}

