/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.config.GatewayConfig;

public class GatewayTestConfig
extends Configuration
implements GatewayConfig {
    public static final boolean DEFAULT_WEBSOCKET_FEATURE_ENABLED = false;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_INPUT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_WEBSOCKET_ASYNC_WRITE_TIMEOUT = 60000;
    public static final int DEFAULT_WEBSOCKET_IDLE_TIMEOUT = 300000;
    private String gatewayHomeDir = "gateway-home";
    private String hadoopConfDir = "hadoop";
    private String gatewayHost = "localhost";
    private int gatewayPort = 0;
    private String gatewayPath = "gateway";
    private boolean hadoopKerberosSecured = false;
    private String kerberosConfig = "/etc/knox/conf/krb5.conf";
    private boolean kerberosDebugEnabled = false;
    private String kerberosLoginConfig = "/etc/knox/conf/krb5JAASLogin.conf";
    private String frontendUrl = null;
    private boolean xForwardedEnabled = true;
    private String gatewayApplicationsDir = null;
    private String gatewayServicesDir;
    private String defaultTopologyName = "default";
    private List<String> includedSSLCiphers = null;
    private List<String> excludedSSLCiphers = null;
    private boolean sslEnabled = false;
    private String truststoreType = "jks";
    private String keystoreType = "jks";
    private boolean isTopologyPortMappingEnabled = true;
    private ConcurrentHashMap<String, Integer> topologyPortMapping = new ConcurrentHashMap();
    private int backupVersionLimit = -1;
    private long backupAgeLimit = -1L;

    public void setGatewayHomeDir(String gatewayHomeDir) {
        this.gatewayHomeDir = gatewayHomeDir;
    }

    public String getGatewayHomeDir() {
        return this.gatewayHomeDir;
    }

    public String getGatewayConfDir() {
        return this.gatewayHomeDir;
    }

    public String getGatewayDataDir() {
        return this.gatewayHomeDir;
    }

    public String getGatewaySecurityDir() {
        return this.gatewayHomeDir + "/security";
    }

    public String getGatewayTopologyDir() {
        return this.gatewayHomeDir + "/topologies";
    }

    public String getGatewayDeploymentDir() {
        return this.gatewayHomeDir + "/deployments";
    }

    public String getHadoopConfDir() {
        return this.hadoopConfDir;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public String getGatewayPath() {
        return this.gatewayPath;
    }

    public void setGatewayPath(String gatewayPath) {
        this.gatewayPath = gatewayPath;
    }

    public InetSocketAddress getGatewayAddress() throws UnknownHostException {
        return new InetSocketAddress(this.getGatewayHost(), this.getGatewayPort());
    }

    public long getGatewayIdleTimeout() {
        return 0L;
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isHadoopKerberosSecured() {
        return this.hadoopKerberosSecured;
    }

    public void setHadoopKerberosSecured(boolean hadoopKerberosSecured) {
        this.hadoopKerberosSecured = hadoopKerberosSecured;
    }

    public String getKerberosConfig() {
        return this.kerberosConfig;
    }

    public void setKerberosConfig(String kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
    }

    public boolean isKerberosDebugEnabled() {
        return this.kerberosDebugEnabled;
    }

    public void setKerberosDebugEnabled(boolean kerberosDebugEnabled) {
        this.kerberosDebugEnabled = kerberosDebugEnabled;
    }

    public String getKerberosLoginConfig() {
        return this.kerberosLoginConfig;
    }

    public String getDefaultTopologyName() {
        return this.defaultTopologyName;
    }

    public void setDefaultTopologyName(String defaultTopologyName) {
        this.defaultTopologyName = defaultTopologyName;
    }

    public String getDefaultAppRedirectPath() {
        if (StringUtils.isBlank((String)this.defaultTopologyName)) {
            return "/gateway/sandbox";
        }
        return "/gateway/" + this.defaultTopologyName;
    }

    public String getFrontendUrl() {
        return this.frontendUrl;
    }

    public void setFrontendUrl(String frontendUrl) {
        this.frontendUrl = frontendUrl;
    }

    public List getExcludedSSLProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("SSLv3");
        return protocols;
    }

    public List getIncludedSSLCiphers() {
        return this.includedSSLCiphers;
    }

    public void setIncludedSSLCiphers(List<String> list) {
        this.includedSSLCiphers = list;
    }

    public List getExcludedSSLCiphers() {
        return this.excludedSSLCiphers;
    }

    public void setExcludedSSLCiphers(List<String> list) {
        this.excludedSSLCiphers = list;
    }

    public boolean isClientAuthNeeded() {
        return false;
    }

    public String getTruststorePath() {
        return null;
    }

    public boolean getTrustAllCerts() {
        return false;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setKerberosLoginConfig(String kerberosLoginConfig) {
        this.kerberosLoginConfig = kerberosLoginConfig;
    }

    public String getGatewayServicesDir() {
        if (this.gatewayServicesDir != null) {
            return this.gatewayServicesDir;
        }
        File targetDir = new File(System.getProperty("user.dir"), "target/services");
        return targetDir.getPath();
    }

    public void setGatewayServicesDir(String gatewayServicesDir) {
        this.gatewayServicesDir = gatewayServicesDir;
    }

    public String getGatewayApplicationsDir() {
        if (this.gatewayApplicationsDir != null) {
            return this.gatewayApplicationsDir;
        }
        return this.getGatewayConfDir() + "/applications";
    }

    public void setGatewayApplicationsDir(String gatewayApplicationsDir) {
        this.gatewayApplicationsDir = gatewayApplicationsDir;
    }

    public boolean isXForwardedEnabled() {
        return this.xForwardedEnabled;
    }

    public void setXForwardedEnabled(boolean enabled) {
        this.xForwardedEnabled = enabled;
    }

    public String getEphemeralDHKeySize() {
        return "2048";
    }

    public int getHttpClientMaxConnections() {
        return 16;
    }

    public int getHttpClientConnectionTimeout() {
        return -1;
    }

    public int getHttpClientSocketTimeout() {
        return -1;
    }

    public int getThreadPoolMax() {
        return 254;
    }

    public int getHttpServerRequestBuffer() {
        return 16384;
    }

    public int getHttpServerRequestHeaderBuffer() {
        return 8192;
    }

    public int getHttpServerResponseBuffer() {
        return 32768;
    }

    public int getHttpServerResponseHeaderBuffer() {
        return 8192;
    }

    public void setGatewayDeploymentsBackupVersionLimit(int newBackupVersionLimit) {
        this.backupVersionLimit = newBackupVersionLimit;
    }

    public int getGatewayDeploymentsBackupVersionLimit() {
        return this.backupVersionLimit;
    }

    public void setTopologyPortMapping(ConcurrentHashMap<String, Integer> topologyPortMapping) {
        this.topologyPortMapping = topologyPortMapping;
    }

    public void setGatewayPortMappingEnabled(boolean topologyPortMappingEnabled) {
        this.isTopologyPortMappingEnabled = topologyPortMappingEnabled;
    }

    public long getGatewayDeploymentsBackupAgeLimit() {
        return this.backupAgeLimit;
    }

    public void setGatewayDeploymentsBackupAgeLimit(long newBackupAgeLimit) {
        this.backupAgeLimit = newBackupAgeLimit;
    }

    public String getSigningKeystoreName() {
        return null;
    }

    public String getSigningKeyAlias() {
        return null;
    }

    public List<String> getGlobalRulesServices() {
        ArrayList<String> services = new ArrayList<String>();
        services.add("WEBHDFS");
        services.add("HBASE");
        services.add("HIVE");
        services.add("OOZIE");
        services.add("RESOURCEMANAGER");
        services.add("STORM");
        return services;
    }

    public boolean isWebsocketEnabled() {
        return false;
    }

    public int getWebsocketMaxTextMessageSize() {
        return Integer.MAX_VALUE;
    }

    public int getWebsocketMaxBinaryMessageSize() {
        return Integer.MAX_VALUE;
    }

    public int getWebsocketMaxTextMessageBufferSize() {
        return 32768;
    }

    public int getWebsocketMaxBinaryMessageBufferSize() {
        return 32768;
    }

    public int getWebsocketInputBufferSize() {
        return 4096;
    }

    public int getWebsocketAsyncWriteTimeout() {
        return 60000;
    }

    public int getWebsocketIdleTimeout() {
        return 300000;
    }

    public boolean isMetricsEnabled() {
        return false;
    }

    public boolean isJmxMetricsReportingEnabled() {
        return false;
    }

    public boolean isGraphiteMetricsReportingEnabled() {
        return false;
    }

    public String getGraphiteHost() {
        return null;
    }

    public int getGraphitePort() {
        return 0;
    }

    public int getGraphiteReportingFrequency() {
        return 0;
    }

    public boolean isCookieScopingToPathEnabled() {
        return false;
    }

    public String getHeaderNameForRemoteAddress() {
        return "X-Forwarded-For";
    }

    public String getAlgorithm() {
        return null;
    }

    public String getPBEAlgorithm() {
        return null;
    }

    public String getTransformation() {
        return null;
    }

    public String getSaltSize() {
        return null;
    }

    public String getIterationCount() {
        return null;
    }

    public String getKeyLength() {
        return null;
    }

    public Map<String, Integer> getGatewayPortMappings() {
        return this.topologyPortMapping;
    }

    public boolean isGatewayPortMappingEnabled() {
        return this.isTopologyPortMappingEnabled;
    }

    public boolean isGatewayServerHeaderEnabled() {
        return false;
    }

    public String getDefaultDiscoveryAddress() {
        return null;
    }

    public String getDefaultDiscoveryCluster() {
        return null;
    }

    public boolean isClientAuthWanted() {
        return false;
    }

    public String getGatewayProvidersConfigDir() {
        return null;
    }

    public String getGatewayDescriptorsDir() {
        return null;
    }

    public List<String> getRemoteRegistryConfigurationNames() {
        return Collections.emptyList();
    }

    public String getRemoteRegistryConfiguration(String s) {
        return null;
    }

    public String getRemoteConfigurationMonitorClientName() {
        return null;
    }

    public boolean isRemoteAliasServiceEnabled() {
        return true;
    }

    public int getClusterMonitorPollingInterval(String type) {
        return 600;
    }

    public boolean isClusterMonitorEnabled(String type) {
        return false;
    }

    public boolean allowUnauthenticatedRemoteRegistryReadAccess() {
        return false;
    }

    public List<String> getReadOnlyOverrideTopologyNames() {
        ArrayList<String> readOnly = new ArrayList<String>();
        String value = this.get("gateway.read.only.override.topologies");
        if (value != null && !value.isEmpty()) {
            readOnly.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        }
        return readOnly;
    }

    public String getKnoxAdminGroups() {
        return null;
    }

    public String getKnoxAdminUsers() {
        return null;
    }

    public String getFederationHeaderName() {
        return "SM_USER";
    }

    public List<String> getAutoDeployTopologyNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("manager");
        names.add("admin");
        return null;
    }

    public String getDispatchWhitelist() {
        return null;
    }

    public List<String> getDispatchWhitelistServices() {
        return Collections.emptyList();
    }

    public boolean isTopologyValidationEnabled() {
        return false;
    }
}

