/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import com.mycila.xmltool.XMLTag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.GatewayTestConfig;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.security.ldap.SimpleLdapDirectoryServer;
import org.apache.knox.gateway.services.DefaultGatewayServices;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.test.mock.MockServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayTestDriver {
    private static Logger log = LoggerFactory.getLogger(GatewayTestDriver.class);
    public Class<?> resourceBaseClass;
    public Map<String, Service> services = new HashMap<String, Service>();
    public SimpleLdapDirectoryServer ldap;
    public TcpTransport ldapTransport;
    public boolean useGateway;
    public GatewayServer gateway;
    public GatewayConfig config;
    public String clusterName;

    public void setResourceBase(Class<?> resourceBaseClass) {
        this.resourceBaseClass = resourceBaseClass;
    }

    public int setupLdap(int port) throws Exception {
        String basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File(".").getCanonicalPath();
        }
        Path path = FileSystems.getDefault().getPath(basedir, "/src/test/resources/users.ldif");
        return this.setupLdap(port, path.toFile());
    }

    public int setupLdap(int port, File ldifConfig) throws Exception {
        this.ldapTransport = new TcpTransport(port);
        this.ldap = new SimpleLdapDirectoryServer("dc=hadoop,dc=apache,dc=org", ldifConfig, new Transport[]{this.ldapTransport});
        this.ldap.start();
        log.info("LDAP port = " + this.ldapTransport.getAcceptor().getLocalAddress().getPort());
        return port;
    }

    public void setupService(String role, String realUrl, String gatewayPath, boolean mock) throws Exception {
        Service service = new Service(role, realUrl, gatewayPath, mock);
        this.services.put(role, service);
        log.info(role + " port = " + service.server.getPort());
    }

    public void setupGateway(GatewayTestConfig config, String cluster, XMLTag topology, boolean use) throws Exception {
        this.useGateway = use;
        this.config = config;
        this.clusterName = cluster;
        File targetDir = new File(System.getProperty("user.dir"), "target");
        File gatewayDir = new File(targetDir, "gateway-home-" + UUID.randomUUID());
        gatewayDir.mkdirs();
        config.setGatewayHomeDir(gatewayDir.getAbsolutePath());
        File topoDir = new File(config.getGatewayTopologyDir());
        topoDir.mkdirs();
        File deployDir = new File(config.getGatewayDeploymentDir());
        deployDir.mkdirs();
        File descriptor = new File(topoDir, cluster + ".xml");
        FileOutputStream stream = new FileOutputStream(descriptor);
        topology.toStream((OutputStream)stream);
        stream.close();
        DefaultGatewayServices srvcs = new DefaultGatewayServices();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("persist-master", "false");
        options.put("master", "password");
        try {
            srvcs.init((GatewayConfig)config, options);
        }
        catch (ServiceLifecycleException e) {
            e.printStackTrace();
        }
        this.gateway = GatewayServer.startGateway((GatewayConfig)config, (GatewayServices)srvcs);
        MatcherAssert.assertThat((String)"Failed to start gateway.", (Object)this.gateway, (Matcher)CoreMatchers.notNullValue());
        log.info("Gateway port = " + this.gateway.getAddresses()[0].getPort());
    }

    public void cleanup() throws Exception {
        if (this.gateway != null) {
            this.gateway.stop();
        }
        if (this.config != null) {
            FileUtils.deleteQuietly((File)new File(this.config.getGatewayTopologyDir()));
            FileUtils.deleteQuietly((File)new File(this.config.getGatewayConfDir()));
            FileUtils.deleteQuietly((File)new File(this.config.getGatewaySecurityDir()));
            FileUtils.deleteQuietly((File)new File(this.config.getGatewayDeploymentDir()));
            FileUtils.deleteQuietly((File)new File(this.config.getGatewayDataDir()));
        }
        for (Service service : this.services.values()) {
            service.server.stop();
        }
        this.services.clear();
        this.ldap.stop(true);
    }

    public boolean isUseGateway() {
        return this.useGateway;
    }

    public MockServer getMock(String serviceRole) {
        Service service = this.services.get(serviceRole);
        return service.server;
    }

    public String getRealUrl(String serviceRole) {
        return this.getUrl(serviceRole, true);
    }

    public String getUrl(String serviceRole) {
        return this.getUrl(serviceRole, false);
    }

    private String getLocalHostName() {
        String hostName = "localhost";
        try {
            hostName = InetAddress.getByName("127.0.0.1").getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    public String getUrl(String serviceRole, boolean real) {
        String localHostName = this.getLocalHostName();
        Service service = this.services.get(serviceRole);
        String url = this.useGateway && !real ? "http://" + localHostName + ":" + this.gateway.getAddresses()[0].getPort() + "/" + this.config.getGatewayPath() + service.gatewayPath : (service.mock ? "http://" + localHostName + ":" + service.server.getPort() : service.realUrl.toASCIIString());
        return url;
    }

    public String getClusterUrl() {
        String localHostName = this.getLocalHostName();
        String url = "http://" + localHostName + ":" + this.gateway.getAddresses()[0].getPort() + "/" + this.config.getGatewayPath() + "/" + this.clusterName;
        return url;
    }

    public int getGatewayPort() {
        return this.gateway.getAddresses()[0].getPort();
    }

    public String getRealAddr(String role) {
        String localHostName = this.getLocalHostName();
        Service service = this.services.get(role);
        String addr = service.mock ? localHostName + ":" + service.server.getPort() : service.realUrl.getHost() + ":" + service.realUrl.getPort();
        return addr;
    }

    public String getLdapUrl() {
        return "ldap://localhost:" + this.ldapTransport.getAcceptor().getLocalAddress().getPort();
    }

    public String getResourceBaseName() {
        return this.resourceBaseClass.getName().replaceAll("\\.", "/") + "/";
    }

    public String getResourceName(String resource) {
        return this.getResourceBaseName() + resource;
    }

    public URL getResourceUrl(String resource) {
        URL url = ClassLoader.getSystemResource(this.getResourceName(resource));
        Assert.assertThat((String)("Failed to find test resource " + resource), (Object)url, (Matcher)Matchers.notNullValue());
        return url;
    }

    public InputStream getResourceStream(String resource) throws IOException {
        InputStream stream = null;
        if (resource.startsWith("file:/")) {
            try {
                stream = FileUtils.openInputStream((File)new File(new URI(resource)));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        } else {
            stream = ClassLoader.getSystemResourceAsStream(this.getResourceName(resource));
        }
        Assert.assertThat((String)("Failed to find test resource " + resource), (Object)stream, (Matcher)Matchers.notNullValue());
        return stream;
    }

    public byte[] getResourceBytes(String resource) throws IOException {
        return IOUtils.toByteArray((InputStream)this.getResourceStream(resource));
    }

    public String getResourceString(String resource) throws IOException {
        return IOUtils.toString((byte[])this.getResourceBytes(resource), (String)StandardCharsets.UTF_8.name());
    }

    public void assertComplete() {
        for (Service service : this.services.values()) {
            if (service.mock) {
                Assert.assertThat((String)("Service " + service.role + " has remaining expected interactions."), (Object)service.server.getCount(), (Matcher)Matchers.is((Object)0));
            }
            service.server.reset();
        }
    }

    public void assertNotComplete(String serviceName) {
        Service service = this.services.get(serviceName);
        if (service != null) {
            if (service.mock) {
                Assert.assertThat((String)("Service " + service.role + " has remaining expected interactions."), (Object)service.server.getCount(), (Matcher)Matchers.not((Object)0));
            }
            service.server.reset();
        } else {
            Assert.fail();
        }
    }

    public void reset() {
        for (Service service : this.services.values()) {
            service.server.reset();
        }
    }

    private static class Service {
        String role;
        URI realUrl;
        String gatewayPath;
        boolean mock;
        MockServer server;

        private Service(String role, String realUrl, String gatewayPath, boolean mock) throws Exception {
            this.role = role;
            this.realUrl = new URI(realUrl);
            this.gatewayPath = gatewayPath;
            this.mock = mock;
            this.server = new MockServer(role, true);
        }
    }
}

