/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.test.mock;

import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.Servlet;
import org.apache.knox.test.mock.MockInteraction;
import org.apache.knox.test.mock.MockRequestMatcher;
import org.apache.knox.test.mock.MockResponseProvider;
import org.apache.knox.test.mock.MockServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private Server jetty;
    private Queue<MockInteraction> interactions = new LinkedList<MockInteraction>();

    public MockServer(String name) {
        this.name = name;
    }

    public MockServer(String name, boolean start) throws Exception {
        this.name = name;
        if (start) {
            this.start();
        }
    }

    public String getName() {
        return this.name;
    }

    public void start() throws Exception {
        ServletContextHandler context = this.createHandler();
        this.jetty = new Server(0);
        this.jetty.setHandler((Handler)context);
        this.jetty.start();
        this.log.info("Mock server started on port " + this.getPort());
    }

    public void stop() throws Exception {
        this.jetty.stop();
        this.jetty.join();
    }

    private ServletContextHandler createHandler() {
        MockServlet servlet = new MockServlet(this.getName(), this.interactions);
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(holder, "/*");
        return context;
    }

    public int getPort() {
        return this.jetty.getURI().getPort();
    }

    public MockRequestMatcher expect() {
        MockInteraction interaction = new MockInteraction();
        this.interactions.add(interaction);
        return interaction.expect();
    }

    public MockResponseProvider respond() {
        MockInteraction interaction = new MockInteraction();
        this.interactions.add(interaction);
        return interaction.respond();
    }

    public int getCount() {
        return this.interactions.size();
    }

    public boolean isEmpty() {
        return this.interactions.isEmpty();
    }

    public void reset() {
        this.interactions.clear();
    }
}

