/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.test.mock;

import java.io.IOException;
import java.util.Queue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.test.mock.MockInteraction;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class MockServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)MockServlet.class.getName());
    public String name;
    public Queue<MockInteraction> interactions;

    public MockServlet(String name, Queue<MockInteraction> interactions) {
        this.name = name;
        this.interactions = interactions;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)("service: request=" + request.getMethod() + " " + request.getRequestURL() + "?" + request.getQueryString()));
        try {
            if (this.interactions.isEmpty()) {
                Assert.fail((String)("Mock servlet " + this.name + " received a request but the expected interaction queue is empty."));
            }
            MockInteraction interaction = this.interactions.remove();
            interaction.expect().match(request);
            interaction.respond().apply(response);
            LOG.debug((Object)("service: response=" + response.getStatus()));
        }
        catch (AssertionError e) {
            LOG.debug((Object)("service: exception=" + ((Throwable)((Object)e)).getMessage()));
            ((Throwable)((Object)e)).printStackTrace();
            throw new ServletException((Throwable)((Object)e));
        }
    }
}

