/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.math.BigInteger;
import java.util.Collections;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class BigLinkedListCommon {
    public static final String TABLE_NAME_KEY = "IntegrationTestBigLinkedList.table";
    public static final String DEFAULT_TABLE_NAME = "IntegrationTestBigLinkedList";
    public static final String HEADS_TABLE_NAME_KEY = "IntegrationTestBigLinkedList.heads_table";
    public static final String DEFAULT_HEADS_TABLE_NAME = "IntegrationTestBigLinkedListHeads";
    public static final String COLUMN_KEY_ONE = "key1";
    public static final int COLUMN_KEY_ONE_IDX = 0;
    public static final String COLUMN_KEY_TWO = "key2";
    public static final int COLUMN_KEY_TWO_IDX = 1;
    public static final String COLUMN_PREV_ONE = "prev1";
    public static final int COLUMN_PREV_ONE_IDX = 2;
    public static final String COLUMN_PREV_TWO = "prev2";
    public static final int COLUMN_PREV_TWO_IDX = 3;
    public static final String COLUMN_ROW_ID = "row_id";
    public static final int COLUMN_ROW_ID_IDX = 4;
    public static final String COLUMN_CLIENT = "client";
    public static final int COLUMN_CLIENT_IDX = 5;
    public static final String COLUMN_UPDATE_COUNT = "update_count";
    public static final int COLUMN_UPDATE_COUNT_IDX = 6;

    public static Schema getTableSchema() {
        return new Schema(ImmutableList.of(new ColumnSchema.ColumnSchemaBuilder(COLUMN_KEY_ONE, Type.INT64).key(true).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_KEY_TWO, Type.INT64).key(true).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_PREV_ONE, Type.INT64).nullable(true).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_PREV_TWO, Type.INT64).nullable(true).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_ROW_ID, Type.INT64).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_CLIENT, Type.STRING).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_UPDATE_COUNT, Type.INT32).build()));
    }

    public static Schema getHeadsTableSchema() {
        return new Schema(ImmutableList.of(new ColumnSchema.ColumnSchemaBuilder(COLUMN_KEY_ONE, Type.INT64).key(true).build(), new ColumnSchema.ColumnSchemaBuilder(COLUMN_KEY_TWO, Type.INT64).key(true).build()));
    }

    public static CreateTableOptions getCreateTableOptions(Schema schema, int numReplicas, int rangePartitions, int hashPartitions) {
        Preconditions.checkArgument(rangePartitions > 0);
        Preconditions.checkArgument(hashPartitions > 0);
        CreateTableOptions options = new CreateTableOptions().setNumReplicas(numReplicas);
        if (rangePartitions > 1) {
            options.setRangePartitionColumns(ImmutableList.of(COLUMN_KEY_ONE));
            BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
            BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
            BigInteger step = max.multiply(BigInteger.valueOf(2L)).divide(BigInteger.valueOf(rangePartitions));
            PartialRow splitRow = schema.newPartialRow();
            for (int i = 1; i < rangePartitions; ++i) {
                long key = min.add(step.multiply(BigInteger.valueOf(i))).longValue();
                splitRow.addLong(0, key);
                options.addSplitRow(splitRow);
            }
        } else {
            options.setRangePartitionColumns(Collections.emptyList());
        }
        if (hashPartitions > 1) {
            options.addHashPartitions(ImmutableList.of(COLUMN_KEY_ONE), hashPartitions);
        }
        return options;
    }

    private BigLinkedListCommon() {
    }

    public static class Xoroshiro128PlusRandom {
        private long state0;
        private long state1;

        public Xoroshiro128PlusRandom() {
            this((long)(Math.random() * 9.223372036854776E18));
        }

        public Xoroshiro128PlusRandom(long seed) {
            long state;
            long z = state = seed + -7046029254386353131L;
            z = (z ^ z >>> 30) * -4658895280553007687L;
            z = (z ^ z >>> 27) * -7723592293110705685L;
            this.state0 = z ^ z >>> 31;
            z = state += this.state0 + -7046029254386353131L;
            z = (z ^ z >>> 30) * -4658895280553007687L;
            z = (z ^ z >>> 27) * -7723592293110705685L;
            this.state1 = z ^ z >>> 31;
        }

        public long nextLong() {
            long s0 = this.state0;
            long s1 = this.state1;
            long result = s0 + s1;
            this.state0 = Long.rotateLeft(s0, 55) ^ (s1 ^= s0) ^ s1 << 14;
            this.state1 = Long.rotateLeft(s1, 36);
            return result;
        }

        public void nextBytes(byte[] bytes) {
            int i = bytes.length;
            int n = 0;
            while (i != 0) {
                n = Math.min(i, 8);
                long bits = this.nextLong();
                while (n-- != 0) {
                    bytes[--i] = (byte)bits;
                    bits >>>= 8;
                }
            }
        }
    }

    public static enum Counts {
        UNREFERENCED,
        UNDEFINED,
        REFERENCED,
        EXTRAREFERENCES;

    }
}

