/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kudu.mapreduce.CommandLineParser;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;
import org.apache.kudu.mapreduce.tools.ImportCsvMapper;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ImportCsv
extends Configured
implements Tool {
    static final String NAME = "importcsv";
    static final String DEFAULT_SEPARATOR = "\t";
    static final String SEPARATOR_CONF_KEY = "importcsv.separator";
    static final String JOB_NAME_CONF_KEY = "importcsv.job.name";
    static final String SKIP_LINES_CONF_KEY = "importcsv.skip.bad.lines";
    static final String COLUMNS_NAMES_KEY = "importcsv.column.names";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, ClassNotFoundException {
        Class<ImportCsvMapper> mapperClass = ImportCsvMapper.class;
        conf.set(COLUMNS_NAMES_KEY, args[0]);
        String tableName = args[1];
        Path inputDir = new Path(args[2]);
        String jobName = conf.get(JOB_NAME_CONF_KEY, "importcsv_" + tableName);
        Job job = new Job(conf, jobName);
        job.setJarByClass(mapperClass);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setNumReduceTasks(0);
        new KuduTableMapReduceUtil.TableOutputFormatConfiguratorWithCommandLineParser(job, tableName).configure();
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        String usage = "Usage: importcsv <colAa,colB,colC> <table.name> <input.dir>\n\nImports the given input directory of CSV data into the specified table.\n\nThe column names of the CSV data must be specified in the form of comma-separated column names.\nOther options that may be specified with -D include:\n  -Dimportcsv.skip.bad.lines=false - fail if encountering an invalid line\n  '-Dimportcsv.separator=|' - eg separate on pipes instead of tabs\n  -Dimportcsv.job.name=jobName - use the specified mapreduce job name for the import.\n" + CommandLineParser.getHelpSnippet();
        System.err.println(usage);
    }

    public int run(String[] otherArgs) throws Exception {
        if (otherArgs.length < 3) {
            ImportCsv.usage("Wrong number of arguments: " + otherArgs.length);
            return -1;
        }
        Job job = ImportCsv.createSubmittableJob(this.getConf(), otherArgs);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int status = ToolRunner.run((Tool)new ImportCsv(), (String[])args);
        System.exit(status);
    }

    public static enum Counters {
        BAD_LINES;

    }
}

