/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;
import org.apache.kudu.mapreduce.tools.CsvParser;
import org.apache.kudu.mapreduce.tools.ImportCsv;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ImportCsvMapper
extends Mapper<LongWritable, Text, NullWritable, Operation> {
    private static final NullWritable NULL_KEY = NullWritable.get();
    private String separator;
    private boolean skipBadLines;
    private Counter badLineCount;
    private CsvParser parser;
    private KuduTable table;
    private Schema schema;

    protected void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.separator = conf.get("importcsv.separator");
        if (this.separator == null) {
            this.separator = "\t";
        }
        this.skipBadLines = conf.getBoolean("importcsv.skip.bad.lines", true);
        this.badLineCount = context.getCounter((Enum)ImportCsv.Counters.BAD_LINES);
        this.parser = new CsvParser(conf.get("importcsv.column.names"), this.separator);
        this.table = KuduTableMapReduceUtil.getTableFromContext((TaskInputOutputContext)context);
        this.schema = this.table.getSchema();
    }

    public void map(LongWritable offset, Text value, Mapper.Context context) throws IOException {
        byte[] lineBytes = value.getBytes();
        try {
            CsvParser.ParsedLine parsed = this.parser.parse(lineBytes, value.getLength());
            Insert insert = this.table.newInsert();
            PartialRow row = insert.getRow();
            block14: for (int i = 0; i < parsed.getColumnCount(); ++i) {
                String colName = parsed.getColumnName(i);
                ColumnSchema col = this.schema.getColumn(colName);
                String colValue = Bytes.getString(parsed.getLineBytes(), parsed.getColumnOffset(i), parsed.getColumnLength(i));
                switch (col.getType()) {
                    case BOOL: {
                        row.addBoolean(colName, Boolean.parseBoolean(colValue));
                        continue block14;
                    }
                    case INT8: {
                        row.addByte(colName, Byte.parseByte(colValue));
                        continue block14;
                    }
                    case INT16: {
                        row.addShort(colName, Short.parseShort(colValue));
                        continue block14;
                    }
                    case INT32: {
                        row.addInt(colName, Integer.parseInt(colValue));
                        continue block14;
                    }
                    case INT64: {
                        row.addLong(colName, Long.parseLong(colValue));
                        continue block14;
                    }
                    case STRING: {
                        row.addString(colName, colValue);
                        continue block14;
                    }
                    case FLOAT: {
                        row.addFloat(colName, Float.parseFloat(colValue));
                        continue block14;
                    }
                    case DOUBLE: {
                        row.addDouble(colName, Double.parseDouble(colValue));
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Type " + (Object)((Object)col.getType()) + " not recognized");
                    }
                }
            }
            context.write((Object)NULL_KEY, (Object)insert);
        }
        catch (CsvParser.BadCsvLineException badLine) {
            if (this.skipBadLines) {
                System.err.println("Bad line at offset: " + offset.get() + ":\n" + badLine.getMessage());
                this.badLineCount.increment(1L);
                return;
            }
            throw new IOException("Failing task because of a bad line", badLine);
        }
        catch (IllegalArgumentException e) {
            if (this.skipBadLines) {
                System.err.println("Bad line at offset: " + offset.get() + ":\n" + e.getMessage());
                this.badLineCount.increment(1L);
                return;
            }
            throw new IOException("Failing task because of an illegal argument", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Failing task since it was interrupted", e);
        }
    }
}

