/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ImportParquetMapper
extends Mapper<LongWritable, Group, NullWritable, Operation> {
    private static final NullWritable NULL_KEY = NullWritable.get();
    private MessageType parquetSchema;
    private KuduTable table;
    private Schema schema;

    protected void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.parquetSchema = MessageTypeParser.parseMessageType((String)conf.get("importparquet.input.schema"));
        this.table = KuduTableMapReduceUtil.getTableFromContext((TaskInputOutputContext)context);
        this.schema = this.table.getSchema();
    }

    public void map(LongWritable key, Group value, Mapper.Context context) throws IOException {
        try {
            Insert insert = this.table.newInsert();
            PartialRow row = insert.getRow();
            block12: for (int i = 0; i < this.parquetSchema.getFields().size(); ++i) {
                String colName = ((Type)this.parquetSchema.getFields().get(i)).getName();
                ColumnSchema col = this.schema.getColumn(colName);
                String colValue = value.getValueToString(i, 0);
                switch (col.getType()) {
                    case BOOL: {
                        row.addBoolean(colName, Boolean.parseBoolean(colValue));
                        continue block12;
                    }
                    case INT8: {
                        row.addByte(colName, Byte.parseByte(colValue));
                        continue block12;
                    }
                    case INT16: {
                        row.addShort(colName, Short.parseShort(colValue));
                        continue block12;
                    }
                    case INT32: {
                        row.addInt(colName, Integer.parseInt(colValue));
                        continue block12;
                    }
                    case INT64: {
                        row.addLong(colName, Long.parseLong(colValue));
                        continue block12;
                    }
                    case STRING: {
                        row.addString(colName, colValue);
                        continue block12;
                    }
                    case FLOAT: {
                        row.addFloat(colName, Float.parseFloat(colValue));
                        continue block12;
                    }
                    case DOUBLE: {
                        row.addDouble(colName, Double.parseDouble(colValue));
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Type " + (Object)((Object)col.getType()) + " not recognized");
                    }
                }
            }
            context.write((Object)NULL_KEY, (Object)insert);
        }
        catch (InterruptedException e) {
            throw new IOException("Failing task since it was interrupted", e);
        }
    }
}

