/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.mapreduce.CommandLineParser;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RowCounter
extends Configured
implements Tool {
    static final String NAME = "rowcounter";
    static final String COLUMN_PROJECTION_KEY = "rowcounter.column.projection";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, ClassNotFoundException {
        String tableName = args[0];
        String jobName = "rowcounter_" + tableName;
        Job job = new Job(conf, jobName);
        Class<RowCounterMapper> mapperClass = RowCounterMapper.class;
        job.setJarByClass(mapperClass);
        job.setMapperClass(mapperClass);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(NullOutputFormat.class);
        String columnProjection = conf.get(COLUMN_PROJECTION_KEY);
        new KuduTableMapReduceUtil.TableInputFormatConfiguratorWithCommandLineParser(job, tableName, columnProjection).configure();
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        String usage = "Usage: rowcounter <table.name>\n\nCounts all the rows in the given table.\n\nOther options that may be specified with -D include:\n  -Drowcounter.column.projection=a,b,c - comma-separated list of columns to read as part of the row count. By default, none are read so that the count is as fast as possible. When specifying columns that are keys, they must be at the beginning.\n" + CommandLineParser.getHelpSnippet();
        System.err.println(usage);
    }

    public int run(String[] otherArgs) throws Exception {
        if (otherArgs.length != 1) {
            RowCounter.usage("Wrong number of arguments: " + otherArgs.length);
            return -1;
        }
        Job job = RowCounter.createSubmittableJob(this.getConf(), otherArgs);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int status = ToolRunner.run((Tool)new RowCounter(), (String[])args);
        System.exit(status);
    }

    static class RowCounterMapper
    extends Mapper<NullWritable, RowResult, NullWritable, NullWritable> {
        RowCounterMapper() {
        }

        protected void map(NullWritable key, RowResult value, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Counters.ROWS).increment(1L);
        }
    }

    public static enum Counters {
        ROWS;

    }
}

