/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.com.google.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kudu.shaded.com.google.common.annotations.Beta;
import org.apache.kudu.shaded.com.google.common.annotations.GwtIncompatible;
import org.apache.kudu.shaded.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Beta
@GwtIncompatible
public final class Closeables {
    @VisibleForTesting
    static final Logger logger = Logger.getLogger(Closeables.class.getName());

    private Closeables() {
    }

    public static void close(@NullableDecl Closeable closeable, boolean swallowIOException) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            if (swallowIOException) {
                logger.log(Level.WARNING, "IOException thrown while closing Closeable.", e);
            }
            throw e;
        }
    }

    public static void closeQuietly(@NullableDecl InputStream inputStream) {
        try {
            Closeables.close(inputStream, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static void closeQuietly(@NullableDecl Reader reader) {
        try {
            Closeables.close(reader, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }
}

