/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl.hive;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;

public class HiveProducerRecord {
    public static final String DELIMITER = ",";
    private final RecordKey key;
    private final List<Object> value;

    public HiveProducerRecord(String dbName, String tableName, Map<String, String> partitionKVs, List<Object> value) {
        this.key = new RecordKey(dbName, tableName, partitionKVs);
        this.value = value;
    }

    public HiveProducerRecord(String tableName, Map<String, String> partitionKVs, List<Object> value) {
        this.key = new RecordKey(tableName, partitionKVs);
        this.value = value;
    }

    public HiveProducerRecord(String dbName, String tableName, List<Object> value) {
        this.key = new RecordKey(dbName, tableName);
        this.value = value;
    }

    public HiveProducerRecord(String tableName, List<Object> value) {
        this.key = new RecordKey(tableName);
        this.value = value;
    }

    public RecordKey key() {
        return this.key;
    }

    public List<Object> value() {
        return this.value;
    }

    public String toString() {
        String value = this.value == null ? "null" : this.value.toString();
        return "HiveProducerRecord(key=" + this.key.toString() + ", value=" + value + ")";
    }

    public String valueToString() {
        if (this.value == null || this.value.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.value.size() - 1; ++i) {
            sb.append(this.value.get(i) + DELIMITER);
        }
        sb.append(this.value.get(this.value.size() - 1));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HiveProducerRecord)) {
            return false;
        }
        HiveProducerRecord that = (HiveProducerRecord)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public class RecordKey {
        public static final String DEFAULT_DB_NAME = "DEFAULT";
        private final String dbName;
        private final String tableName;
        private final Map<String, String> partitionKVs;

        public RecordKey(String dbName, String tableName, Map<String, String> partitionKVs) {
            this.dbName = Strings.isNullOrEmpty((String)dbName) ? DEFAULT_DB_NAME : dbName;
            this.tableName = tableName;
            this.partitionKVs = partitionKVs;
        }

        public RecordKey(String tableName, Map<String, String> partitionKVs) {
            this(null, tableName, partitionKVs);
        }

        public RecordKey(String dbName, String tableName) {
            this(dbName, tableName, null);
        }

        public RecordKey(String tableName) {
            this(null, tableName, null);
        }

        public String database() {
            return this.dbName;
        }

        public String table() {
            return this.tableName;
        }

        public Map<String, String> partition() {
            return this.partitionKVs;
        }

        public String toString() {
            String partitionKVs = this.partitionKVs == null ? "null" : this.partitionKVs.toString();
            return "RecordKey(database=" + this.dbName + ", table=" + this.tableName + ", partition=" + partitionKVs + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RecordKey)) {
                return false;
            }
            RecordKey that = (RecordKey)o;
            if (this.dbName != null ? !this.dbName.equals(that.dbName) : that.dbName != null) {
                return false;
            }
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
                return false;
            }
            return !(this.partitionKVs != null ? !this.partitionKVs.equals(that.partitionKVs) : that.partitionKVs != null);
        }

        public int hashCode() {
            int result = this.dbName != null ? this.dbName.hashCode() : 0;
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.partitionKVs != null ? this.partitionKVs.hashCode() : 0);
            return result;
        }
    }
}

